/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.resolve;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.resolve.CMakeCommandReference;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import com.jetbrains.cmake.resolve.CMakeResolveLog;
import org.jetbrains.annotations.NotNull;

public class CMakeCommandDefinitionReference
extends CMakeCommandReference {
    public CMakeCommandDefinitionReference(PsiElement element, TextRange textRange) {
        super(element, textRange);
        CMakeResolveLog.LOG.assertTrue(CMakeCommandReferenceHelper.isCommandDefinition(this.myElement) || CMakeCommandReferenceHelper.isEndCommandDefinition(this.myElement));
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        CMakeRenameUtils.renameArgument(this.myElement.getProject(), newElementName, this.myElement.getNode());
        return this.myElement;
    }

    @Override
    protected ResolveResult[] multiResolveWithoutCaching() {
        CMakeArgument commandDefinitionName;
        if (CMakeCommandReferenceHelper.isCommandDefinition(this.myElement)) {
            return new ResolveResult[]{new PsiElementResolveResult(this.myElement)};
        }
        CMakeArgument elementArgument = null;
        if (this.myElement instanceof CMakeLiteral) {
            elementArgument = ((CMakeLiteral)this.myElement).getArgument();
        } else if (this.myElement instanceof CMakeArgument) {
            elementArgument = (CMakeArgument)this.myElement;
        }
        if (elementArgument != null && (commandDefinitionName = elementArgument.getCommandDefinitionName()) != null) {
            return new ResolveResult[]{new PsiElementResolveResult((PsiElement)commandDefinitionName)};
        }
        return super.multiResolveWithoutCaching();
    }
}

