/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.util.events.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.jetbrains.cidr.CidrUtilsBundle;
import com.jetbrains.cidr.util.events.impl.ChromeTracingEventTracer;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/util/events/impl/ToggleChromeTracingAction;", "Lcom/intellij/openapi/project/DumbAwareToggleAction;", "()V", "myIsRunning", "", "myTimeStarted", "", "productCode", "", "Lorg/jetbrains/annotations/NotNull;", "getProductCode", "()Ljava/lang/String;", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "startTracing", "stopTracingAndDump", "intellij.cidr.util"})
public final class ToggleChromeTracingAction
extends DumbAwareToggleAction {
    private boolean myIsRunning = Boolean.getBoolean("cidr.enable.json.tracer");
    private long myTimeStarted = System.currentTimeMillis();

    private final String getProductCode() {
        return ApplicationInfo.getInstance().getBuild().getProductCode();
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        return this.myIsRunning;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        this.setSelected(state);
    }

    private final void setSelected(boolean state) {
        this.myIsRunning = state;
        if (this.myIsRunning) {
            this.startTracing();
        } else {
            this.stopTracingAndDump();
        }
    }

    private final void startTracing() {
        this.myTimeStarted = System.currentTimeMillis();
        ChromeTracingEventTracer.Companion.getInstance().startTracing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void stopTracingAndDump() {
        long duration = (System.currentTimeMillis() - this.myTimeStarted) / (long)1000;
        String fileNamePrefix = new SimpleDateFormat('\'' + this.getProductCode() + "-trace.'yyyy-MM-dd-HH-mm-ss'-[" + duration + "sec]'").format(new Date());
        File outFile = FileUtil.createTempFile((File)new File(SystemProperties.getUserHome()), (String)fileNamePrefix, (String)".json.gz", (boolean)false, (boolean)false);
        Object object = outFile;
        boolean bl = false;
        object = new GZIPOutputStream((OutputStream)new FileOutputStream((File)object), 65536);
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        object = new OutputStreamWriter((OutputStream)object, charset);
        boolean bl3 = false;
        bl2 = false;
        Throwable throwable = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl4 = false;
            ChromeTracingEventTracer.Companion.getInstance().write(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Notifications.Bus.notify((Notification)new Notification("System Messages", CidrUtilsBundle.message("chrome.trace.title", new Object[0]), CidrUtilsBundle.message("chrome.trace.message", outFile.getPath()), NotificationType.INFORMATION));
        ChromeTracingEventTracer.Companion.getInstance().stopTracing();
    }

    public ToggleChromeTracingAction() {
        super(CidrUtilsBundle.message("chrome.action.trace.text", new Object[0]));
        if (this.myIsRunning) {
            this.startTracing();
        }
    }
}

