/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolsUtil {
    public static final int READ_VERSION_TIMEOUT = 10000;
    public static final int PATH_CACHE_SIZE = 10000;

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrToolsUtil.runWithProgress((BaseProcessHandler)handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler handler, int timeout) {
        ProgressIndicator indicator = CidrToolsUtil.getProgressIndicator();
        ProcessOutput result2 = CidrToolsUtil.runProcess(handler, indicator, timeout);
        if (result2.isCancelled()) {
            throw new ProcessCanceledException();
        }
        return result2;
    }

    public static ProcessOutput runProcess(@NotNull BaseProcessHandler h, @Nullable ProgressIndicator indicator, int timeout) {
        return CidrToolsUtil.runProcess(new CapturingProcessRunner(h), indicator, timeout);
    }

    private static ProcessOutput runProcess(@NotNull CapturingProcessRunner runner, @Nullable ProgressIndicator indicator, int timeout) {
        return indicator == null ? runner.runProcess(timeout) : runner.runProcess(indicator, timeout);
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        try {
            ProcessOutput output = CidrToolsUtil.runWithProgress((BaseProcessHandler)new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        public final String message;

        public Status(@NotNull StatusCode code, @NotNull String message) {
            this.code = code;
            this.message = message;
        }

        public static Status error(@NotNull String message) {
            return new Status(StatusCode.ERROR, message);
        }

        public static Status of(@NotNull Pair<Boolean, String> status) {
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }
    }

    public static enum StatusCode {
        OK,
        WARNING,
        ERROR;

    }
}

