/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.progress.ProgressIndicator;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HostMachine {
    public boolean isRemote();

    @NotNull
    public OSType getOSType();

    @NotNull
    public ProcessOutput runProcess(@NotNull GeneralCommandLine var1, @Nullable ProgressIndicator var2, int var3) throws ExecutionException;

    @NotNull
    default public BaseProcessHandler createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        return this.createProcess(cl, colored, usePty, false);
    }

    public BaseProcessHandler createProcess(@NotNull GeneralCommandLine var1, boolean var2, boolean var3, boolean var4) throws ExecutionException;

    public void destroyProcess(@NotNull BaseProcessHandler var1);

    public void killProcessTree(@NotNull BaseProcessHandler var1);

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException;

    public int sendSignal(int var1, @NotNull String var2);

    @NotNull
    public Path getPath(String var1, String ... var2);

    @NotNull
    public String toCanonicalPath(@NotNull String var1, boolean var2);

    @NotNull
    public Path getTempDirectory();

    @NotNull
    public Path createTempDirectory(@NotNull String var1, @Nullable String var2) throws IOException;

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException;

    @NotNull
    public File resolvePath(@NotNull Path var1) throws IOException;

    @NotNull
    public File resolvePath(@NotNull File var1) throws IOException;

    @NotNull
    public List<File> resolveAndCache(@NotNull List<String> var1);

    @NotNull
    public String getHostId();

    default public void invalidateCache() {
    }

    @NotNull
    default public String getName() {
        return (this.isRemote() ? "Remote " : "Local ") + (Object)((Object)this.getOSType());
    }
}

