/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class HeadersSearchPath {
    private static final int RECURSIVE = 1;
    private static final int KIND = 2;
    private static final int FRAMEWORK = 4;
    private static final int BUILTIN = 8;
    @NotNull
    private final String myPath;
    private final int myFlags;

    public HeadersSearchPath(@NotNull String path, int flags) {
        this.myPath = path;
        this.myFlags = flags;
    }

    public HeadersSearchPath(@NotNull File file2, boolean recursive, @NotNull Kind kind) {
        this(file2.getPath(), recursive, kind);
    }

    public HeadersSearchPath(@NotNull String path, boolean recursive, @NotNull Kind kind) {
        this(path, recursive, kind, false);
    }

    public HeadersSearchPath(@NotNull File file2, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath) {
        this(file2.getPath(), recursive, kind, frameworksSearchPath);
    }

    public HeadersSearchPath(@NotNull File file2, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath, boolean systemSeachPath) {
        this(file2.getPath(), recursive, kind, frameworksSearchPath, systemSeachPath);
    }

    public HeadersSearchPath(@NotNull String path, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath) {
        this(path, recursive, kind, frameworksSearchPath, false);
    }

    public HeadersSearchPath(@NotNull String path, boolean recursive, @NotNull Kind kind, boolean frameworksSearchPath, boolean builtInSearchPath) {
        this(path, (recursive ? 1 : 0) | kind.ordinal() * 2 | (frameworksSearchPath ? 4 : 0) | (builtInSearchPath ? 8 : 0));
    }

    @NotNull
    public static HeadersSearchPath includes(@NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.SYSTEM);
    }

    @NotNull
    public static HeadersSearchPath includes(@NotNull File file2) {
        return HeadersSearchPath.includes(file2.getPath());
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.USER);
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NotNull File file2) {
        return HeadersSearchPath.builtInIncludes(file2.getPath());
    }

    @NotNull
    public static HeadersSearchPath builtInIncludes(@NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.SYSTEM, false, true);
    }

    @NotNull
    public static HeadersSearchPath userIncludes(@NotNull File file2) {
        return HeadersSearchPath.userIncludes(file2.getPath());
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NotNull String path) {
        return new HeadersSearchPath(path, false, Kind.SYSTEM, true);
    }

    @NotNull
    public static HeadersSearchPath frameworks(@NotNull File file2) {
        return HeadersSearchPath.frameworks(file2.getPath());
    }

    @NotNull
    public String getPath() {
        return this.myPath;
    }

    @NotNull
    public String getUrl() {
        return VfsUtilCore.pathToUrl((String)this.myPath);
    }

    public boolean isRecursive() {
        return (this.myFlags & 1) != 0;
    }

    @NotNull
    public Kind getKind() {
        boolean isUser = (this.myFlags & 2) != 0;
        return Kind.fromBoolean(isUser);
    }

    public boolean isBuiltInHeaders() {
        return (this.myFlags & 8) != 0;
    }

    public boolean isFrameworksSearchPath() {
        return (this.myFlags & 4) != 0;
    }

    public int getFlags() {
        return this.myFlags;
    }

    public boolean isAncestorOf(@NotNull VirtualFile file2, boolean checkRecursive) {
        return FileUtil.pathsEqual((String)this.getPath(), (String)file2.getParent().getPath()) || (this.isRecursive() || !checkRecursive) && FileUtil.isAncestor((String)this.getPath(), (String)file2.getPath(), (boolean)true);
    }

    @NotNull
    public HeadersSearchPath createNonRecursiveChildPath(@NotNull String path) {
        if (!this.isRecursive()) {
            return this;
        }
        return new HeadersSearchPath(path, this.getFlags() ^ 1);
    }

    public String toString() {
        return "HeadersSearchPath{" + this.myPath + ", " + this.getKind().toString() + ", " + (this.isRecursive() ? "recursive" : "non-recursive") + (this.isFrameworksSearchPath() ? ", frameworks" : "") + (this.isBuiltInHeaders() ? ", builtin" : "") + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HeadersSearchPath that = (HeadersSearchPath)o;
        if (this.myFlags != that.myFlags) {
            return false;
        }
        return FileUtil.pathsEqual((String)this.myPath, (String)that.myPath);
    }

    public int hashCode() {
        int result2 = FileUtil.pathHashCode((String)this.myPath);
        result2 = 31 * result2 + this.myFlags;
        return result2;
    }

    public static enum Kind {
        SYSTEM,
        USER;


        @NotNull
        public String toString() {
            switch (this) {
                case SYSTEM: {
                    return "system";
                }
                case USER: {
                    return "user";
                }
            }
            throw new IllegalArgumentException(this.name());
        }

        public boolean isSystem() {
            return this == SYSTEM;
        }

        public boolean isUser() {
            return this == USER;
        }

        @NotNull
        public static Kind fromBoolean(boolean isUser) {
            return isUser ? USER : SYSTEM;
        }
    }

    @FunctionalInterface
    public static interface FilePointerFactory {
        @NotNull
        public VirtualFilePointer create(@NotNull String var1);
    }
}

