/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import icons.CidrProjectModelIcons;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AppleFramework
extends HeadersRoot {
    public static final String HEADERS_DIR_NAME = "Headers";
    public static final String PRIVATE_HEADERS_DIR_NAME = "PrivateHeaders";
    public static final String MODULES_DIR_NAME = "Modules";
    public static final String FRAMEWORKS_DIR_NAME = "Frameworks";
    public static final String[] HEADERS_DIR_NAMES = new String[]{"Headers", "PrivateHeaders"};
    @NotNull
    private final String myName;

    protected AppleFramework(@NotNull Project project2, @NotNull String name) {
        super(project2);
        this.myName = name;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public abstract PsiFileSystemItem getParentSdkOrFrameworkItem();

    public boolean isLibrary() {
        return false;
    }

    public abstract boolean containsHeader(@Nullable VirtualFile var1);

    public boolean process(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2, @NotNull Set<String> processed) {
        if (!processed.add(this.getName())) {
            return true;
        }
        if (processor2 instanceof HeadersSearchRootProcessor) {
            return this.processChildren(processor2);
        }
        if (this.isValid()) {
            return AppleFramework.processFileSystemItem(processor2, (PsiFileSystemItem)this);
        }
        return true;
    }

    public boolean processChildren(@NotNull PsiElementProcessor<PsiFileSystemItem> processor2) {
        if (processor2 instanceof HeadersSearchRootProcessor) {
            HeadersSearchRootProcessor.FrameworkResult result2 = ((HeadersSearchRootProcessor)processor2).processFramework(this);
            switch (result2) {
                case ABORT: {
                    return false;
                }
                case SKIP_CHILDREN: {
                    return true;
                }
            }
        }
        return this.processFrameworkChildren(processor2);
    }

    protected abstract boolean processFrameworkChildren(PsiElementProcessor<PsiFileSystemItem> var1);

    public static boolean isFrameworkRoot(@NotNull VirtualFile file2) {
        return file2.isDirectory() && file2.getName().endsWith(".framework");
    }

    public Icon getIcon(int flags) {
        return CidrProjectModelIcons.Framework;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AppleFramework framework = (AppleFramework)((Object)o);
        return this.myName.equals(framework.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public abstract String toString();
}

