/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFakeFunctionSymbolBuilder {
    @NotNull
    private final String myName;
    @NotNull
    private OCType myReturnType = OCVoidType.instance();
    @Nullable
    private OCSymbolWithQualifiedName myContainer = null;
    @NotNull
    private List<Pair<OCType, String>> myParams = new ArrayList<Pair<OCType, String>>();
    private boolean myIsConst = false;
    private boolean myIsCtorOrDtor = false;
    private int myProperties = 0;
    private int myAttributes = 0;
    @NotNull
    private OCVisibility myVisibility = OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC;

    public OCFakeFunctionSymbolBuilder(@NotNull String name) {
        this.myName = name;
    }

    public OCFakeFunctionSymbolBuilder setReturnType(@NotNull OCType type) {
        this.myReturnType = type;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setContainer(@Nullable OCSymbolWithQualifiedName container) {
        this.myContainer = container;
        return this;
    }

    public OCFakeFunctionSymbolBuilder addParam(@NotNull OCType type, @NotNull String name) {
        this.myParams.add((Pair<OCType, String>)Pair.create((Object)type, (Object)name));
        return this;
    }

    public OCFakeFunctionSymbolBuilder setVisibility(@NotNull OCVisibility visibility) {
        this.myVisibility = visibility;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsStatic(boolean isStatic) {
        this.myAttributes = isStatic ? this.myAttributes | OCSymbolAttribute.STATIC.getMask() : this.myAttributes & ~OCSymbolAttribute.STATIC.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsConst(boolean isConst) {
        this.myIsConst = isConst;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsCtorOrDtor(boolean isCtorOrDtor) {
        this.myIsCtorOrDtor = isCtorOrDtor;
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsVirtual(boolean isVirtual) {
        this.myAttributes = isVirtual ? this.myAttributes | OCSymbolAttribute.VIRTUAL.getMask() : this.myAttributes & ~OCSymbolAttribute.VIRTUAL.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsFriend(boolean friend) {
        this.myAttributes = friend ? this.myAttributes | OCSymbolAttribute.FRIEND.getMask() : this.myAttributes & ~OCSymbolAttribute.FRIEND.getMask();
        return this;
    }

    public OCFakeFunctionSymbolBuilder setIsOperator(boolean operator) {
        this.myProperties = operator ? this.myProperties | OCFunctionSymbol.Property.IS_OPERATOR.getMask() : this.myProperties & ~OCFunctionSymbol.Property.IS_OPERATOR.getMask();
        return this;
    }

    @NotNull
    public OCFunctionSymbol get() {
        List parameterSymbols = ContainerUtil.map(this.myParams, pair -> new OCDeclaratorSymbolImpl(null, Long.MAX_VALUE, null, OCQualifiedName.interned((String)pair.second), Collections.emptyList(), (OCType)pair.first, OCSymbolKind.PARAMETER, null, Collections.emptyList(), null, OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null));
        List parameterTypes = ContainerUtil.map(this.myParams, pair -> (OCType)pair.first);
        List parameterNames = ContainerUtil.map(this.myParams, pair -> (String)pair.second);
        OCFunctionType funcType = new OCFunctionType(this.myReturnType, parameterTypes, parameterNames, this.myIsConst, false, false, false, OCExceptionSpecificationInfo.createForNone());
        return new OCFunctionSymbol(null, Long.MAX_VALUE, this.myContainer, OCQualifiedName.interned(this.myName), Collections.emptyList(), null, this.myProperties, this.myAttributes, Collections.emptyList(), funcType, OCTypeUtils.getDefaultValues(false, parameterSymbols), this.myIsCtorOrDtor ? OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION : OCSymbolKind.FUNCTION_DECLARATION, this.myVisibility);
    }
}

