/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class OCLongActionUtil {
    public static final String TIMEOUT_PROPERTY = "cidr.resolve.in.ui.timeout";
    public static final int DEFAULT_TIMEOUT = 5000;
    public static boolean ourAutoCancelLongAction = false;

    public static void setAutoCancelLongAction(boolean autoCancelLongAction) {
        ourAutoCancelLongAction = autoCancelLongAction;
    }

    private static int getTimeoutInMs(@NotNull String timeoutPropertyName) {
        try {
            return Integer.parseInt(System.getProperty(timeoutPropertyName, String.valueOf(5000)));
        }
        catch (Throwable ignored) {
            return 5000;
        }
    }

    @Nullable
    public static <T> T execWithTimeoutProgressInDispatch(@PropertyKey(resourceBundle="messages.OCBundle") @NotNull String descriptorIdForIndicator, @NotNull String timeoutPropertyName, @Nullable Project project2, Computable<T> longAction) {
        ProgressIndicator progress;
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && (progress = OCLongActionUtil.installTimeoutIndicatorIfNeed(descriptorIdForIndicator, timeoutPropertyName, project2)) != null) {
            try {
                return (T)ProgressManager.getInstance().runProcess(longAction, progress);
            }
            catch (ProcessCanceledException pie) {
                if (progress.isCanceled()) {
                    OCLog.LOG.warn(descriptorIdForIndicator, new Throwable(pie));
                }
                throw pie;
            }
        }
        return (T)longAction.compute();
    }

    @Nullable
    private static ProgressIndicator installTimeoutIndicatorIfNeed(@PropertyKey(resourceBundle="messages.OCBundle") @NotNull String descriptorIdForIndicator, @NotNull String timeoutPropertyName, @Nullable Project project2) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            return null;
        }
        return new WatchDogIndicator(OCLongActionUtil.getTimeoutInMs(timeoutPropertyName), project2, descriptorIdForIndicator);
    }

    @Nullable(value="null if the timeout is exceeded")
    public static <T> @Nullable(value="null if the timeout is exceeded") T runReadActionInBackgroundAndWait(Computable<T> computable, long maxTimeoutMs) {
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            throw new UnsupportedOperationException("This method is not needed in background thread (let your caller cancel you instead)");
        }
        if (application.isWriteAccessAllowed()) {
            throw new UnsupportedOperationException("This method can't be run in write action (it'll deadlock waiting for read action in spawned thread)");
        }
        Ref result2 = Ref.create();
        Semaphore semaphore = new Semaphore(1);
        Runnable cancellableRunnable = () -> {
            result2.set(application.runReadAction(computable));
            semaphore.up();
        };
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        application.executeOnPooledThread(() -> OCLongActionUtil.lambda$runReadActionInBackgroundAndWait$1(cancellableRunnable, (ProgressIndicator)indicator));
        try {
            if (!semaphore.waitFor(maxTimeoutMs)) {
                indicator.cancel();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        return (T)result2.get();
    }

    private static /* synthetic */ void lambda$runReadActionInBackgroundAndWait$1(Runnable cancellableRunnable, ProgressIndicator indicator) {
        ProgressManager.getInstance().runProcess(cancellableRunnable, indicator);
    }

    static class WatchDogIndicator
    extends AbstractProgressIndicatorExBase
    implements PingProgress,
    StandardProgressIndicator {
        private final long myStartTimeMs;
        private final long myTimeOutMs;
        private final Project myProject;
        @PropertyKey(resourceBundle="messages.OCBundle")
        private final String myDescriptorIdForIndicator;
        private PotemkinProgress myProgress;
        private boolean myTriggered;

        WatchDogIndicator(long timeOutMs, @Nullable Project project2, @PropertyKey(resourceBundle="messages.OCBundle") @NotNull String descriptorIdForIndicator) {
            this.myTimeOutMs = timeOutMs;
            this.myDescriptorIdForIndicator = descriptorIdForIndicator;
            this.myStartTimeMs = System.currentTimeMillis();
            this.myProject = project2;
            this.myTriggered = false;
            this.setIndeterminate(true);
        }

        public final boolean isCanceled() {
            if (!this.myTriggered && System.currentTimeMillis() - this.myStartTimeMs >= this.myTimeOutMs) {
                this.myTriggered = true;
                if (ourAutoCancelLongAction) {
                    this.cancel();
                } else if (this.myProgress == null && ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isHeadlessEnvironment() && !ApplicationManager.getApplication().isUnitTestMode()) {
                    List titles = StringUtil.split((String)OCBundle.message(this.myDescriptorIdForIndicator, new Object[0]), (String)"\n");
                    if (titles.size() > 1) {
                        this.setText((String)titles.get(1));
                    }
                    if (titles.size() > 2) {
                        this.setText2((String)titles.get(2));
                    }
                    this.myProgress = new PotemkinProgress((String)titles.get(0), this.myProject, null, CommonBundle.getCancelButtonText());
                    this.myProgress.start();
                    this.addStateDelegate((ProgressIndicatorEx)this.myProgress);
                }
            }
            return super.isCanceled();
        }

        public void interact() {
            if (this.myProgress != null) {
                this.myProgress.interact();
            }
        }
    }
}

