/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCStructType
extends OCTypeCompatibilityVisitor<OCStructType> {
    protected OCTypeCompatibilityVisitor_OCStructType(@NotNull OCStructType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context2, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM && !((OCStructType)this.mySourceType).isEnumClass()) {
            return new OCTypeCheckResult(OCTypeCheckState.WARNING);
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        OCTypeCheckResult result2;
        OCType lTerminalType = type.getTerminalType();
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false) && !lTerminalType.isUnknown() && type.isPointerToPointerToObjectCompatible() ^ ((OCStructType)this.mySourceType).isPointerToPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcEnabled(this.myContext.getContainingFile()) && (result2 = this.checkArcBridgeCast(type, false)) != null) {
            return result2;
        }
        boolean isCpp = this.myResolveContext.isCpp();
        if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        if (type.isPointerToVoid() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, this.myAllowImplicitConversions) && !isCpp) {
            return OCTypeCheckResult.createOK();
        }
        if (((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
            return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
        }
        return this.visitType(type);
    }

    @Override
    protected OCTypeCheckResult checkRefType(OCCppReferenceType type) {
        OCTypeCheckResult result2 = super.checkRefType(type);
        if (this.myContext instanceof OCCastExpression && result2.getState().isError(this.myContext) && this.isCppClassType(type.getTerminalType()) && ((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT) {
            result2.setState(OCTypeCheckState.WARNING);
        }
        return result2;
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        OCFunctionDefinition declaringFun;
        if (OCTollFreeBridges.isCompatible(this.mySourceType, type)) {
            return OCTypeCheckResult.createOK();
        }
        if (type.getKind() == OCSymbolKind.ENUM) {
            if (((OCStructType)this.mySourceType).getKind() == OCSymbolKind.ENUM) {
                if (((OCStructType)this.mySourceType).equals(type, false, this.myResolveContext)) {
                    return OCTypeCheckResult.createOK();
                }
                return new OCTypeCheckResult(OCTypeCheckState.ERROR_IF_CPP);
            }
            Computable message = null;
            if (((OCStructType)this.mySourceType).isIntegerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from integer";
            } else if (!type.isEnumClass() && ((OCStructType)this.mySourceType).isPointerCompatible(this.myResolveContext, false)) {
                message = () -> "Taking enum type '" + type.getBestNameInContext(this.myResolveContext) + "' from pointer";
            }
            if (message != null) {
                return this.checkAssignToEnum(type);
            }
        }
        OCFunctionSymbol declaringSymbol = (declaringFun = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myContext, OCFunctionDefinition.class)) != null ? declaringFun.getSymbol() : null;
        boolean isFunctionReturnTypeContext = this.myContext.getParent() instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)this.myContext.getParent()).getReturnTypeElement() == this.myContext;
        for (OCStructSymbol struct : type.getStructs()) {
            OCTypeCheckResult result2 = this.processTransparentUnion(struct, type);
            if (result2 != null) {
                return result2;
            }
            if (this.myIsSecondStepOfCopyInit) {
                if (new OCTypeEqualityVisitor(type, true, true, this.myResolveContext).equal(this.mySourceType)) {
                    return OCTypeCheckResult.createOK();
                }
            } else if (this.myAllowImplicitConversions) {
                result2 = OCTypeCompatibilityVisitor_OCStructType.processConstructors(struct, this.mySourceType, this.mySource, this.myContext, this.myResolveContext, this.myIsCopyInitWithSameClass);
            }
            if (((OCFile)this.myContext.getContainingFile()).isCpp() && ((OCStructType)this.mySourceType).getKind() == OCSymbolKind.STRUCT && this.isCppClassType(type)) {
                boolean isInsideClass = declaringSymbol != null && declaringSymbol.getResolvedOwner(this.myResolveContext) instanceof OCStructSymbol && struct.isAncestor((OCStructSymbol)declaringSymbol.getResolvedOwner(this.myResolveContext), this.myResolveContext);
                for (OCStructSymbol symbol : ((OCStructType)this.mySourceType).getStructs()) {
                    Ref visibilityRef = new Ref();
                    if (!symbol.processAllBaseClasses(OCResolveContext.forPsi(this.myContext), (baseSymbol, visibility) -> {
                        if (baseSymbol instanceof OCStructSymbol && ((OCStructSymbol)baseSymbol).resolvedNamesEqual(this.myResolveContext.getProject(), struct) || baseSymbol instanceof OCTypeParameterSymbol) {
                            visibilityRef.set((Object)visibility);
                            return false;
                        }
                        return true;
                    }, isInsideClass)) {
                        if (!isFunctionReturnTypeContext && (!isInsideClass && visibilityRef.get() != OCVisibility.PUBLIC || visibilityRef.get() == OCVisibility.PRIVATE)) {
                            if (result2 == null) {
                                result2 = OCTypeCheckResult.createError();
                            }
                        } else {
                            return result2 != null ? result2 : OCTypeCheckResult.createOK();
                        }
                    }
                    if (result2 != null) continue;
                    result2 = OCTypeCheckResult.createError();
                }
            }
            if (result2 == null) continue;
            return result2;
        }
        return this.visitType(type);
    }
}

