/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types.visitors;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCTypeCompatibilityVisitor_OCObjectType
extends OCTypeCompatibilityVisitor<OCObjectType> {
    protected OCTypeCompatibilityVisitor_OCObjectType(@NotNull OCObjectType sourceType, @Nullable OCTypeOwner source, @Nullable PsiElement context2, boolean allowImplicitConversions, boolean assumeNullSubstitutionsEquals, @NotNull OCResolveContext resolveContext) {
        super(sourceType, source, context2, allowImplicitConversions, assumeNullSubstitutionsEquals, resolveContext);
    }

    @Override
    public OCTypeCheckResult visitFunctionType(OCFunctionType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitObjectType(OCObjectType type) {
        boolean compatibleClass = type.isAncestorOf((OCObjectType)this.mySourceType) || ((OCObjectType)this.mySourceType).isKindof() && ((OCObjectType)this.mySourceType).isAncestorOf(type);
        OCInterfaceSymbol anInterface = ((OCObjectType)this.mySourceType).getInterface();
        OCInterfaceSymbol typeInterface = type.getInterface();
        if (!compatibleClass && anInterface != null && typeInterface != null) {
            return new OCTypeCheckResult(OCTypeCheckState.WARNING);
        }
        if (!((OCObjectType)this.mySourceType).isKindof()) {
            return this.getProtocolCompatibilityCheckResult((OCObjectType)this.mySourceType, type);
        }
        return OCTypeCheckResult.createOK();
    }

    @Override
    public OCTypeCheckResult visitPointerType(OCPointerType type) {
        return this.visitType(type);
    }

    @Override
    public OCTypeCheckResult visitStructType(OCStructType type) {
        return this.checkStructCompatibleCtor(type);
    }
}

