/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArrayType
extends OCPointerType {
    @Nullable
    private OCExpressionSymbol myLength;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCArrayType() {
        this(null, null, false, false, null, OCTypeSubstitution.ID);
    }

    public OCArrayType(OCType ref, @Nullable OCExpressionSymbol length, boolean isConst, boolean isVolatile, @Nullable ARCAttribute attribute, @NotNull OCTypeSubstitution substitution2) {
        super(ref, attribute, null, OCNullability.NONNULL, isConst, isVolatile);
        this.myLength = length;
        this.mySubstitution = substitution2;
    }

    public int getLength(@NotNull OCResolveContext context2) {
        if (this.myLength == null) {
            return -1;
        }
        Number result2 = OCExpressionEvaluator.evaluate(this.myLength, context2);
        return result2 != null ? result2.intValue() : -1;
    }

    public boolean hasLength() {
        return this.myLength != null;
    }

    @Nullable
    public OCExpressionSymbol getLengthSymbol() {
        return this.myLength;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCArrayType f = (OCArrayType)first;
        OCArrayType s = (OCArrayType)second;
        return c.equalObjects(f.myLength, s.myLength) && super.deepEqualStep(c, first, second);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.myLength != null ? this.myLength.hashCode() : 0);
        return result2;
    }

    public boolean isEmpty(HashSet<OCStructSymbol> processed, @NotNull OCResolveContext resolveContext) {
        if (this.getLength(resolveContext) == 0) {
            return true;
        }
        OCType elementType = this.myRefType.resolve(resolveContext);
        if (elementType instanceof OCArrayType) {
            if (!((OCArrayType)elementType).isEmpty(processed, resolveContext)) {
                return false;
            }
        } else if (elementType instanceof OCStructType) {
            if (!((OCStructType)elementType).isEmpty(processed, resolveContext)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    public static OCArrayType to(OCType type, int length, @Nullable ARCAttribute arcAttribute) {
        return new OCArrayType(type, OCArrayType.lengthFromInt(length), false, false, arcAttribute, OCTypeSubstitution.ID);
    }

    public static OCArrayType to(OCType ref, int length) {
        return OCArrayType.to(ref, length, null);
    }

    public static OCArrayType to(OCType type, OCExpressionSymbol length, @Nullable ARCAttribute arcAttribute) {
        return new OCArrayType(type, length, false, false, arcAttribute, OCTypeSubstitution.ID);
    }

    public static OCArrayType to(OCType ref, OCExpressionSymbol length) {
        return OCArrayType.to(ref, length, null);
    }

    @Override
    public <T> T accept(OCTypeVisitor<T> visitor) {
        return visitor.visitArrayType(this);
    }

    @Override
    @NotNull
    public OCType getArrayElementType() {
        return this.myRefType.getArrayElementType();
    }

    public static OCExpressionSymbol lengthFromInt(int length) {
        if (length == -1) {
            return null;
        }
        return new OCLiteralExpressionSymbol(length, null, null);
    }
}

