/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.LocalHost;
import java.io.File;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolEnvironment {
    public static final String UNIX_FILE_SEPARATORS = "/";
    public static final String WINDOWS_UNIX_FILE_SEPARATORS = "/\\";
    protected final boolean isWindows;

    public CidrToolEnvironment() {
        this(SystemInfo.isWindows);
    }

    public CidrToolEnvironment(boolean isWindows) {
        this.isWindows = isWindows;
    }

    public void prepare(@NotNull GeneralCommandLine cl, @NotNull PrepareFor prepareFor) throws ExecutionException {
    }

    @Contract(value="null -> null")
    public final String toLocalPath(@Nullable String absoluteEnvPath) {
        return this.toLocalPath(null, absoluteEnvPath);
    }

    @Contract(value="_, null -> null")
    public String toLocalPath(@Nullable File localBaseDir, @Nullable String absoluteOrRelativeEnvPath) {
        if (absoluteOrRelativeEnvPath == null) {
            return null;
        }
        if (localBaseDir != null && !this.isEnvAbsolute(absoluteOrRelativeEnvPath)) {
            String baseDirPath = StringsKt.trimEnd((String)localBaseDir.getPath(), ch -> this.getSupportedFileSeparators().contains(ch.charValue()));
            absoluteOrRelativeEnvPath = FileUtil.toCanonicalPath((String)(baseDirPath + UNIX_FILE_SEPARATORS + absoluteOrRelativeEnvPath));
        }
        return absoluteOrRelativeEnvPath;
    }

    protected boolean isEnvAbsolute(@NotNull String absoluteOrRelativeEnvPath) {
        return this.isWindows ? FileUtil.isWindowsAbsolutePath((String)absoluteOrRelativeEnvPath) : FileUtil.isUnixAbsolutePath((String)absoluteOrRelativeEnvPath);
    }

    @Contract(value="null -> null")
    public String toEnvPath(@Nullable String localPath) {
        return localPath;
    }

    @NotNull
    public CidrFileSeparators getSupportedFileSeparators() {
        return this.isWindows ? CidrFileSeparators.WINDOWS_UNIX : CidrFileSeparators.UNIX;
    }

    public HostMachine getHostMachine() {
        return LocalHost.INSTANCE;
    }

    public static enum PrepareFor {
        BUILD,
        RUN;

    }
}

