/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class OCFileSymbolTableModificationTracker
extends SimpleModificationTracker {
    private State state = new State();
    public static final Logger LOG = Logger.getInstance(OCFileSymbolTableModificationTracker.class);

    public OCFileSymbolTableModificationTracker(@NotNull Project project2) {
        project2.getMessageBus().connect((Disposable)project2).subscribe(OCFileSymbolTableListener.TOPIC, (Object)new OCFileSymbolTableListener(){

            @Override
            public void onFileHasNewSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                OCFileSymbolTableModificationTracker.log("FST add ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithNewSymbolTable(virtualFile);
            }

            @Override
            public void onFileHasInvalidSymbolTableInPack(@NotNull VirtualFile virtualFile) {
                OCFileSymbolTableModificationTracker.log("FST remove ", virtualFile);
                OCFileSymbolTableModificationTracker.this.addFileWithInvalidTable(virtualFile);
            }

            @Override
            public void onAllSymbolTablesDropped() {
                OCFileSymbolTableModificationTracker.log("FST clear all", new Object[0]);
                OCFileSymbolTableModificationTracker.this.reset();
            }
        });
    }

    synchronized long attachAndReturnCurrentVersion(@NotNull OCGlobalProjectSymbolsCache.OCSymbols symbols) {
        this.state.symbols = symbols;
        return this.getModificationCount();
    }

    synchronized void restoreStateOnCancel(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
        this.state.restore(canceledState, beforeBuildSymbols);
    }

    @NotNull
    synchronized State getStateAndReset() {
        State ret = this.state;
        ret.version = this.getModificationCount();
        this.state = new State();
        return ret;
    }

    synchronized void reset() {
        this.state = new State();
        this.incModificationCount();
    }

    synchronized void addFileWithNewSymbolTable(@NotNull VirtualFile file2) {
        this.state.filesWithNewSymbolTable.add(file2);
        this.incModificationCount();
    }

    synchronized void addFileWithInvalidTable(@NotNull VirtualFile file2) {
        this.state.filesWithInvalidSymbolTable.add(file2);
        this.incModificationCount();
    }

    public static OCFileSymbolTableModificationTracker getInstance(@NotNull Project project2) {
        return (OCFileSymbolTableModificationTracker)((Object)ServiceManager.getService((Project)project2, OCFileSymbolTableModificationTracker.class));
    }

    public static void log(@NotNull String message, Object ... details) {
        LOG.debug(message, details);
    }

    public static class State {
        public OCGlobalProjectSymbolsCache.OCSymbols symbols = null;
        public final Set<VirtualFile> filesWithNewSymbolTable = new HashSet<VirtualFile>();
        public final Set<VirtualFile> filesWithInvalidSymbolTable = new HashSet<VirtualFile>();
        public long version = -1L;

        public void restore(@NotNull State canceledState, @NotNull OCGlobalProjectSymbolsCache.OCSymbols beforeBuildSymbols) {
            this.filesWithNewSymbolTable.addAll(canceledState.filesWithNewSymbolTable);
            this.filesWithInvalidSymbolTable.addAll(canceledState.filesWithInvalidSymbolTable);
            assert (this.symbols == null);
            this.symbols = beforeBuildSymbols;
            this.version = -1L;
        }
    }
}

