/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCMethodSymbol
extends OCMemberSymbol,
OCSymbolWithSubstitution {
    public static final String INSTANCETYPE = "instancetype";

    @NotNull
    public OCType getReturnType(@Nullable OCObjectType var1, @NotNull Project var2);

    public boolean isOptional();

    public boolean isVararg();

    @Nullable
    public OCSymbol getOriginalSymbol();

    @NotNull
    public List<SelectorPartSymbol> getSelectors();

    @NotNull
    public List<OCDeclaratorSymbol> getParameterSymbols();

    @Override
    @Nullable
    public OCMethodSymbol getAssociatedSymbol(@NotNull Project var1);

    @NotNull
    default public OCType getReturnType(@NotNull Project project2) {
        return this.getReturnType(null, project2);
    }

    default public boolean isFactoryMethod() {
        return OCMethodSymbolImpl.isFactoryMethod(this);
    }

    default public boolean isConstructorMethod() {
        return !this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "init");
    }

    default public boolean isClassConstructorMethod() {
        return this.isStatic() && OCElementUtil.startsWithWord(this.getName(), "objectWith");
    }

    @Override
    @Nullable
    default public OCMethodSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (this.isPredeclaration()) {
            return this.getAssociatedSymbol(project2);
        }
        return this;
    }

    default public boolean isGetter(@NotNull OCResolveContext context2) {
        return OCNameSuggester.isObjCGetter(this.getName()) && !this.getEffectiveResolvedType(context2).isVoid();
    }

    default public boolean isSetter(@NotNull OCResolveContext context2) {
        return OCNameSuggester.isObjCSetter(this.getName()) && this.getEffectiveResolvedType(context2).isVoid();
    }

    @Deprecated
    default public OCPropertySymbol getGeneratedFromProperty() {
        OCSymbol originalSymbol = this.getOriginalSymbol();
        return originalSymbol instanceof OCPropertySymbol ? (OCPropertySymbol)originalSymbol : null;
    }

    default public boolean isAccessorWithAliasedName(@NotNull Project project2) {
        return OCMethodSymbolImpl.isAccessorWithAliasedName(this, project2);
    }

    @Override
    @NotNull
    default public String getSignature(@NotNull Project project2) {
        return (this.isStatic() ? "+" : "-") + this.getName();
    }

    @Nullable
    default public OCMethodSymbol getAssociatedSymbol(@Nullable PsiElement context2, @NotNull Project project2) {
        return OCMethodSymbolImpl.getAssociatedSymbol(this, context2, project2);
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull PsiElement context2) {
        return OCTypeUtils.changeTypeReferences(this.getReturnType(context2.getProject()), OCSymbolReference.getLocalReference(this.getName(), context2));
    }

    @NotNull
    default public OCType getEffectiveType(@Nullable OCObjectType receiverType, @NotNull PsiElement context2) {
        return OCTypeUtils.changeTypeReferences(this.getReturnType(receiverType, context2.getProject()), OCSymbolReference.getLocalReference(this.getName(), context2));
    }

    public static interface SelectorPartSymbol
    extends DeepEqual.Equality<SelectorPartSymbol>,
    Serializable,
    OCSymbolWithSubstitution {
        @Nullable
        public OCDeclaratorSymbol getParameter();

        @Nullable
        public OCDeclaratorSymbol getParameterWithoutSubstitution();

        @Nullable
        public String getSelectorName();
    }
}

