/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.psi.impl.OCConditionalExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCConditionalExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCondition;
    private OCExpressionSymbol myLeftOperand;
    private OCExpressionSymbol myRightOperand;

    public OCConditionalExpressionSymbol() {
    }

    public OCConditionalExpressionSymbol(@Nullable VirtualFile file2, long offset, OCExpressionSymbol condition, OCExpressionSymbol leftOperand, OCExpressionSymbol rightOperand) {
        super(file2, offset);
        this.myCondition = condition;
        this.myLeftOperand = leftOperand;
        this.myRightOperand = rightOperand;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCConditionalExpressionSymbol firstSymbol = (OCConditionalExpressionSymbol)first;
        OCConditionalExpressionSymbol secondSymbol = (OCConditionalExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCondition, secondSymbol.myCondition)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLeftOperand, secondSymbol.myLeftOperand)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myRightOperand, secondSymbol.myRightOperand);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context2) {
        OCType leftType = this.myLeftOperand.getResolvedType(context2);
        OCType rightType = this.myRightOperand.getResolvedType(context2);
        if (leftType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)leftType).getSymbol());
        }
        if (rightType instanceof OCTypeParameterType) {
            context2.addTypeDependency(((OCTypeParameterType)rightType).getSymbol());
        }
        return OCConditionalExpressionImpl.calcConditionalExprType(leftType, this.myLeftOperand, rightType, this.myRightOperand, context2);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return (T)evaluator.evalConditional(this.myCondition.evaluate(evaluator), () -> this.myLeftOperand.evaluate(evaluator), () -> this.myRightOperand.evaluate(evaluator));
    }

    public OCExpressionSymbol getLeftOperandOrCondition() {
        return this.myLeftOperand == null ? this.myCondition : this.myLeftOperand;
    }

    public OCExpressionSymbol getCondition() {
        return this.myCondition;
    }

    public OCExpressionSymbol getLeftOperand() {
        return this.myLeftOperand;
    }

    public OCExpressionSymbol getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myCondition.getPresentableName() + " ?" + (this.myLeftOperand == null ? "" : " " + this.myLeftOperand.getPresentableName() + " ") + ": " + this.myRightOperand.getPresentableName();
    }
}

