/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class OCSymbolHolderBase<T extends OCSymbol>
extends FakePsiElement
implements NavigatablePsiElement {
    @NotNull
    protected final T mySymbol;
    @NotNull
    protected final Project myProject;

    public OCSymbolHolderBase(@NotNull T symbol, @NotNull Project project2) {
        this.mySymbol = symbol;
        this.myProject = project2;
    }

    @NotNull
    public String getName() {
        return this.mySymbol.getName();
    }

    public ItemPresentation getPresentation() {
        return new OCSymbolPresentation((OCSymbol)this.mySymbol, this.myProject);
    }

    protected Icon getBaseIcon() {
        return this.mySymbol.getIcon(this.getProject());
    }

    public Icon getIcon(boolean open) {
        return this.mySymbol.getIcon(this.getProject());
    }

    public void navigate(boolean requestFocus) {
        int offset = this.mySymbol.getOffset();
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        if (virtualFile != null && virtualFile.isValid()) {
            PsiNavigationSupport.getInstance().createNavigatable(this.myProject, virtualFile, offset).navigate(true);
        }
    }

    public boolean canNavigateToSource() {
        VirtualFile virtualFile = this.mySymbol.getContainingFile();
        return virtualFile != null && virtualFile.isValid();
    }

    public PsiElement getParent() {
        return this.mySymbol.getContainingPsiFile(this.getProject());
    }

    public PsiFile getContainingFile() {
        return this.mySymbol.getContainingPsiFile(this.getProject());
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public int getTextOffset() {
        return this.mySymbol.getOffset();
    }

    public TextRange getTextRange() {
        return new TextRange(this.mySymbol.getOffset(), this.mySymbol.getOffset());
    }

    public void delete() throws IncorrectOperationException {
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && this.mySymbol.equals(((OCSymbolHolderBase)((Object)obj)).mySymbol);
    }

    public int hashCode() {
        return this.mySymbol.hashCode();
    }

    @NotNull
    public T getSymbol() {
        return this.mySymbol;
    }
}

