/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCResolveContext
extends UserDataHolderBase
implements OCCompilationContext {
    public static final Key<Boolean> FAIL_ON_RESOLVE_CYCLE = Key.create((String)"FAIL_ON_RESOLVE_CYCLE");
    @Nullable
    private final PsiElement myElement;
    @Nullable
    private final Project myProject;
    @NotNull
    private final OCTypeSubstitution mySubstitution;
    @NotNull
    private final Set<Pair<OCSymbolReference, OCTypeSubstitution>> myResolving;
    private final HashMap<OCFunctionSymbol, OCStructSymbol> myOperatorParentsCache;
    private final Set<OCTypeResolveVisitor.TypeKey> myResolvingTypes;
    private final OCExpressionEvaluator.ValueEvaluator myEvaluator;
    private Map<OCType, OCType> myAutoParamsTypeMapping;
    private Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> myAutoParamsValueMapping;
    @Nullable
    private OCResolveContext myOriginalContext;
    private int myDepth;
    private Ref<Integer> myTypeResolveCounter = Ref.create((Object)0);
    private final Stack<OCFunctionSymbol> myOuterFunctions = new Stack();
    private Set<OCTypeParameterSymbol> myTypeDependencies;
    private boolean myProcessNonImported;
    private boolean myOriginallyProcessNonImported;
    private boolean myDontExpandVariadics;
    private boolean isVariadicExpansionMode;
    private boolean myDontUseSymbolContextsInDepends;
    private boolean myInSFINAE;
    private boolean myIncompleteMode;
    private boolean myUseSecondCache = true;
    private int myTemplateSubstitutionsCnt;
    private boolean myMsvcExtensionsCapable = true;

    @Deprecated
    @NotNull
    public static OCResolveContext empty(@NotNull Project project2) {
        return new OCResolveContext(null, project2);
    }

    @NotNull
    public static OCResolveContext forSymbol(@NotNull OCSymbol symbol, @NotNull Project project2) {
        return new OCResolveContext(symbol.getContainingOCFile(project2), project2);
    }

    @NotNull
    public static OCResolveContext forPsi(@NotNull PsiElement element) {
        return new OCResolveContext(OCPsiFile.tryGetElementFromOCFile(element), element.getProject());
    }

    @Deprecated
    @NotNull
    public static OCResolveContext forNullablePsi(@Nullable PsiElement element, @NotNull Project project2) {
        return new OCResolveContext(OCPsiFile.tryGetElementFromOCFile(element), project2);
    }

    private OCResolveContext(@NotNull OCResolveContext origin, @NotNull OCTypeSubstitution substitution2) {
        this.myProject = origin.myProject;
        this.myOriginalContext = origin;
        this.myDepth = origin.myDepth + 1;
        this.myElement = origin.myElement;
        this.mySubstitution = substitution2;
        this.myResolving = origin.myResolving;
        this.myResolvingTypes = origin.myResolvingTypes;
        this.myOperatorParentsCache = origin.myOperatorParentsCache;
        this.myTypeResolveCounter = origin.myTypeResolveCounter;
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = origin.myEvaluator;
        this.myIncompleteMode = origin.myIncompleteMode;
        this.myMsvcExtensionsCapable = origin.myMsvcExtensionsCapable;
    }

    private OCResolveContext(@Nullable PsiElement element, @Nullable Project project2) {
        this.myProject = project2;
        this.myElement = element;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    @Deprecated
    @NotNull
    public static OCResolveContext emptyContextWithoutProject() {
        return new OCResolveContext();
    }

    @Deprecated
    private OCResolveContext() {
        this.myProject = null;
        this.myElement = null;
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myResolving = OCTypeUtils.newReferenceWithSubstitutionSet();
        this.myResolvingTypes = new THashSet();
        this.myOperatorParentsCache = new HashMap();
        this.myTypeDependencies = new HashSet<OCTypeParameterSymbol>();
        this.myEvaluator = new OCExpressionEvaluator.ValueEvaluator(this);
    }

    public String toString() {
        String element;
        if (this.myElement instanceof OCFile) {
            OCFile file2 = (OCFile)this.myElement;
            element = "file " + file2.getName();
        } else {
            element = this.myElement != null ? "element " + this.myElement.getClass().getSimpleName() + ": " + this.myElement.getText() : (this.myProject != null ? "project " + this.myProject.getName() : "<null (deprecated)>");
        }
        return "OCResolveContext(" + element + ")";
    }

    public List<OCSymbol> doResolveToSymbols(OCSymbolReference reference, boolean onlyTypes, boolean resolveSpecializations) {
        Pair pair = Pair.create((Object)reference, (Object)this.mySubstitution.getMinimalDependentSubstitution(reference, this));
        if (this.myResolving.contains(pair)) {
            if (this.getProject().getUserData(FAIL_ON_RESOLVE_CYCLE) == Boolean.TRUE) {
                throw new RuntimeException("Cycle in resolve, use \"//Allow resolve cycle\" in tests to suppress this assertion");
            }
            return Collections.emptyList();
        }
        this.myResolving.add((Pair<OCSymbolReference, OCTypeSubstitution>)pair);
        List<OCSymbol> result2 = reference.resolveToSymbols(this, onlyTypes, resolveSpecializations);
        this.myResolving.remove(pair);
        return result2;
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference) {
        return this.resolveToSymbols(reference, false, false);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean onlyTypes) {
        return this.resolveToSymbols(reference, processTypedefs, true, onlyTypes);
    }

    public List<OCSymbol> resolveToSymbols(OCSymbolReference reference, boolean processTypedefs, boolean processTypeParameters, boolean onlyTypes) {
        List<OCSymbol> symbols = this.doResolveToSymbols(reference, onlyTypes, true);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, this, symbols, reference, processTypeParameters, true);
    }

    public Set<OCTypeResolveVisitor.TypeKey> getResolvingTypes() {
        return this.myResolvingTypes;
    }

    public Set<OCQualifiedName> getResolvingTypeNames() {
        return this.myResolvingTypes.stream().map(OCTypeResolveVisitor.TypeKey::getTypeName).collect(Collectors.toSet());
    }

    @Nullable
    public OCStructSymbol getNonMemberOperatorParent(OCSymbol operator) {
        if (operator instanceof OCFunctionSymbol) {
            OCFunctionSymbol function = (OCFunctionSymbol)operator;
            List<OCDeclaratorSymbol> params = function.getParameterSymbols();
            if (function.isCppNonMemberOperator(this)) {
                if (this.myOperatorParentsCache.containsKey(function)) {
                    return this.myOperatorParentsCache.get(function);
                }
                OCStructSymbol result2 = null;
                boolean wasUnknown = false;
                this.myOperatorParentsCache.put(function, null);
                for (int i2 = 0; i2 < params.size(); ++i2) {
                    OCDeclaratorSymbol parameter = operator.getName().equals("operator<<") ? params.get(params.size() - i2 - 1) : params.get(i2);
                    OCType paramType = parameter.getType().resolve(this).getTerminalType();
                    if (paramType instanceof OCStructType) {
                        result2 = ((OCStructType)paramType).getSymbol();
                        break;
                    }
                    if (!(paramType instanceof OCUnknownType)) continue;
                    wasUnknown = true;
                }
                if (result2 == null && wasUnknown) {
                    this.myOperatorParentsCache.remove(function);
                } else {
                    this.myOperatorParentsCache.put(function, result2);
                }
                return result2;
            }
        }
        return null;
    }

    @Nullable
    public PsiFile getFile() {
        return OCElementUtil.getContainingFileSkippingFragments(this.myElement);
    }

    @Deprecated
    @Nullable
    public PsiElement getElement() {
        return this.myElement != null && this.myElement.isValid() ? this.myElement : null;
    }

    @Deprecated
    @Nullable
    public Project getProjectOrNull() {
        return this.myProject;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Nullable
    public OCResolveContext getOriginalContext() {
        return this.myOriginalContext;
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution2) {
        return this.substitute(substitution2, false, false);
    }

    @NotNull
    public OCResolveContext substitute(@NotNull OCTypeSubstitution substitution2, boolean overwriteSubstitution, boolean createIfID) {
        if (substitution2 != OCTypeSubstitution.ID || createIfID) {
            OCResolveContext result2 = new OCResolveContext(this, OCTypeSubstitution.compose(this.mySubstitution, substitution2, overwriteSubstitution));
            result2.setProcessNonImported(this.myProcessNonImported);
            return result2;
        }
        return this;
    }

    @NotNull
    public OCResolveContext substituteFirst(@NotNull OCTypeSubstitution substitution2) {
        if (substitution2 != OCTypeSubstitution.ID) {
            OCResolveContext result2 = new OCResolveContext(this, OCTypeSubstitution.compose(substitution2, this.mySubstitution, false));
            result2.setProcessNonImported(this.myProcessNonImported);
            return result2;
        }
        return this;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCSymbol symbol) {
        OCTypeSubstitution substitution2 = this.mySubstitution.getMinimalDependentSubstitution(symbol, this);
        substitution2 = symbol instanceof OCSymbolWithSubstitution ? OCTypeSubstitution.compose(substitution2, ((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution(), false) : substitution2;
        OCResolveContext result2 = new OCResolveContext(this, substitution2);
        result2.setProcessNonImported(this.myProcessNonImported);
        return result2;
    }

    @NotNull
    public OCResolveContext useFor(@NotNull OCTypeArgument argument, @NotNull OCTypeSubstitution substitution2) {
        substitution2 = OCTypeSubstitution.compose(this.mySubstitution, substitution2, false).getMinimalDependentSubstitution(argument, this);
        OCResolveContext result2 = new OCResolveContext(this, substitution2);
        result2.setProcessNonImported(this.myProcessNonImported);
        return result2;
    }

    @NotNull
    public OCResolveContext clearSubstitution() {
        OCResolveContext result2 = new OCResolveContext(this, OCTypeSubstitution.ID);
        result2.setProcessNonImported(this.myProcessNonImported);
        return result2;
    }

    @NotNull
    public OCResolveContext clone() {
        return new OCResolveContext(this, this.mySubstitution);
    }

    public int getNestingDepth() {
        return this.myDepth;
    }

    public OCExpressionEvaluator.ValueEvaluator getEvaluator() {
        return new OCExpressionEvaluator.ValueEvaluator(this.myEvaluator, this);
    }

    public boolean isProcessNonImported() {
        return this.myProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isProcessNonImported();
    }

    public boolean isInSFINAE() {
        return this.myInSFINAE || this.myOriginalContext != null && this.myOriginalContext.isInSFINAE();
    }

    public boolean isOriginallyProcessNonImported() {
        return this.myOriginallyProcessNonImported || this.myOriginalContext != null && this.myOriginalContext.isOriginallyProcessNonImported();
    }

    public boolean isDontExpandVariadics() {
        return this.myDontExpandVariadics || this.myOriginalContext != null && this.myOriginalContext.isDontExpandVariadics();
    }

    public void setDontExpandVariadics(boolean dontExpandVariadics) {
        this.myDontExpandVariadics = dontExpandVariadics;
    }

    public boolean isVariadicExpansionMode() {
        return this.isVariadicExpansionMode;
    }

    public void setVariadicExpansionMode(boolean variadicExpansionMode) {
        this.isVariadicExpansionMode = variadicExpansionMode;
    }

    public boolean isMsvcExtensionsCapable() {
        return this.myMsvcExtensionsCapable;
    }

    public void setMsvcExtensionsCapable(boolean msvcExtensionsCapable) {
        this.myMsvcExtensionsCapable = msvcExtensionsCapable;
    }

    public void addTypeDependency(@NotNull OCTypeParameterSymbol dependency) {
        this.myTypeDependencies.add(dependency);
    }

    public void addTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        this.myTypeDependencies.addAll(typeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies() {
        return new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
    }

    @NotNull
    public Set<OCTypeParameterSymbol> getTypeDependencies(@Nullable OCType extraDependenciesSource) {
        final HashSet<OCTypeParameterSymbol> dependencies = new HashSet<OCTypeParameterSymbol>(this.myTypeDependencies);
        if (extraDependenciesSource != null) {
            extraDependenciesSource.accept(new OCBooleanTypeVisitor(){

                @Override
                public Boolean visitTypeParameterType(OCTypeParameterType type) {
                    dependencies.add(type.getSymbol());
                    return true;
                }
            });
        }
        return dependencies;
    }

    public void setTypeDependencies(@NotNull Set<OCTypeParameterSymbol> typeDependencies) {
        this.myTypeDependencies = typeDependencies;
    }

    public void clearTypeDependencies() {
        this.myTypeDependencies.clear();
    }

    public boolean wasDependentType() {
        return !this.myTypeDependencies.isEmpty() || this.myOriginalContext != null && this.myOriginalContext.wasDependentType();
    }

    public int getTypeResolveCounter() {
        return (Integer)this.myTypeResolveCounter.get();
    }

    public void incTypeResolveCounter() {
        this.myTypeResolveCounter.set((Object)((Integer)this.myTypeResolveCounter.get() + 1));
    }

    public void setProcessNonImported(boolean processNonImported) {
        this.myProcessNonImported = processNonImported;
        if (this.myProcessNonImported) {
            this.myOriginallyProcessNonImported = true;
        }
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setProcessNonImported(processNonImported);
        }
    }

    public void setInSFINAE(boolean inSFINAE) {
        this.myInSFINAE = inSFINAE;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.setInSFINAE(inSFINAE);
        }
    }

    public void setIncompleteMode(boolean incompleteMode) {
        this.myIncompleteMode = incompleteMode;
    }

    public boolean isIncompleteMode() {
        return this.myIncompleteMode;
    }

    public void setDontUseSymbolContextsInDepends(boolean flag) {
        this.myDontUseSymbolContextsInDepends = flag;
    }

    public boolean dontUseSymbolContextsInDepends() {
        return this.myDontUseSymbolContextsInDepends;
    }

    public static boolean setNonImportedFlag(@NotNull OCResolveContext context2, boolean value) {
        boolean result2 = context2.isProcessNonImported();
        context2.setProcessNonImported(value);
        return result2;
    }

    public static boolean setInSFINAEFlag(@NotNull OCResolveContext context2, boolean value) {
        boolean result2 = context2.isInSFINAE();
        context2.setInSFINAE(value);
        return result2;
    }

    public OCTypeParameterType getAutoParamTypeMapping(OCAutoType type) {
        return this.myAutoParamsTypeMapping != null ? (OCTypeParameterType)this.myAutoParamsTypeMapping.get(type) : null;
    }

    public void setAutoParamsTypeMapping(Map<OCType, OCType> autoParamsTypeMapping) {
        this.myAutoParamsTypeMapping = autoParamsTypeMapping;
    }

    @Nullable
    public OCTypeParameterValueSymbol getAutoParamValueMapping(@NotNull OCDeclaratorSymbol symbol) {
        return this.myAutoParamsValueMapping != null ? this.myAutoParamsValueMapping.get(symbol) : null;
    }

    public void setAutoParamsValueMapping(Map<OCDeclaratorSymbol, OCTypeParameterValueSymbol> autoParamsValueMapping) {
        this.myAutoParamsValueMapping = autoParamsValueMapping;
    }

    public boolean useSecondCache() {
        return this.myUseSecondCache;
    }

    public void setUseSecondCache(boolean useSecondCache) {
        this.myUseSecondCache = useSecondCache;
    }

    public void incTemplateSubstitutionsCnt() {
        ++this.myTemplateSubstitutionsCnt;
        if (this.myOriginalContext != null) {
            this.myOriginalContext.incTemplateSubstitutionsCnt();
        }
    }

    public int getTemplateSubstitutionsCnt() {
        return this.myTemplateSubstitutionsCnt;
    }

    @Override
    public boolean isCpp() {
        return !OCCodeInsightUtil.isInPlainOldC(this.myElement);
    }

    public boolean isObjc() {
        return OCCodeInsightUtil.isInObjC(this.myElement);
    }

    public void pushOuterFunction(@NotNull OCFunctionSymbol functionSymbol) {
        this.myOuterFunctions.push((Object)functionSymbol);
    }

    public void popOuterFunction() {
        this.myOuterFunctions.pop();
    }

    @Nullable
    public OCFunctionSymbol peekOuterFunction() {
        return this.myOuterFunctions.isEmpty() ? null : (OCFunctionSymbol)this.myOuterFunctions.peek();
    }
}

