/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.symtable.OCQualifiedNamesInterner;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedName
implements Serializable,
DeepEqual.Equality<OCQualifiedName> {
    @NotNull
    private static final String GLOBAL_NAME = "";
    @NotNull
    public static final OCQualifiedName GLOBAL = new OCQualifiedName(null, "");
    @Nullable
    protected OCQualifiedName myQualifier;
    @Nullable
    protected String myName;

    protected OCQualifiedName() {
    }

    protected OCQualifiedName(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        this.myQualifier = qualifier;
        this.myName = name;
    }

    public static OCQualifiedName interned(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        OCQualifiedName result2 = OCQualifiedName.with(qualifier, name);
        return result2 == GLOBAL ? result2 : OCQualifiedNamesInterner.intern(result2);
    }

    public static OCQualifiedName with(@Nullable OCQualifiedName qualifier, @Nullable String name) {
        if (qualifier == null && GLOBAL_NAME.equals(name)) {
            return GLOBAL;
        }
        return new OCQualifiedName(qualifier, name);
    }

    public static OCQualifiedName interned(@Nullable String name) {
        return OCQualifiedName.interned(null, name);
    }

    public static OCQualifiedName with(@Nullable String name) {
        return OCQualifiedName.with(null, name);
    }

    public static boolean areResolvedNamesEquals(@Nullable OCQualifiedName a, @Nullable OCQualifiedName b, @NotNull OCResolveContext context2) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        return a.resolvedEqualsStep(b, context2);
    }

    protected boolean resolvedEqualsStep(@NotNull OCQualifiedName other, @NotNull OCResolveContext context2) {
        if (!Objects.equals(this.myName, other.myName)) {
            return false;
        }
        return OCQualifiedName.areResolvedNamesEquals(this.myQualifier, other.myQualifier, context2);
    }

    @Nullable
    public OCQualifiedName getQualifier() {
        return this.myQualifier;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public OCQualifiedName dropArguments() {
        if (this.myQualifier != null) {
            return OCQualifiedName.with(this.myQualifier.dropArguments(), this.myName);
        }
        return this;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (!Objects.equals(first.myName, second.myName)) {
            return false;
        }
        return c.equalObjects(first.myQualifier, second.myQualifier);
    }

    public boolean canThisNamePartBeInterned() {
        return true;
    }

    public final boolean equals(@Nullable Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    public int hashCode() {
        int result2 = this.myQualifier != null ? this.myQualifier.hashCode() : 0;
        result2 = 31 * result2 + (this.myName != null ? this.myName.hashCode() : 0);
        return result2;
    }

    public String getSuperQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getSuperQualifier();
    }

    public boolean isAbsolute() {
        if (this == GLOBAL) {
            return true;
        }
        if (this.myQualifier == null) {
            return false;
        }
        return this.myQualifier.isAbsolute();
    }

    @NotNull
    public OCQualifiedName dropSuperQualifier() {
        if (this.myQualifier == null) {
            return this;
        }
        if (this.myQualifier.myQualifier == null) {
            return this.changeQualifier(null);
        }
        return this.changeQualifier(this.myQualifier.dropSuperQualifier());
    }

    @NotNull
    public OCQualifiedName changeName(@Nullable String name) {
        if (Objects.equals(this.myName, name)) {
            return this;
        }
        return OCQualifiedName.with(this.myQualifier, name);
    }

    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return OCQualifiedName.with(qualifier, this.myName);
    }

    public OCQualifiedName append(OCQualifiedName name) {
        OCQualifiedName appended = OCQualifiedName.with(this, name.getSuperQualifier());
        return name.getQualifier() == null ? appended : appended.append(name.dropSuperQualifier());
    }

    public String getFullName(@NotNull OCResolveContext context2) {
        return this.getCanonicalName(OCType.Presentation.FULL, true, context2, 0);
    }

    private String doGetShortName() {
        return this.myName != null ? this.myName : "<anonymous>";
    }

    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context2, int templateDepth) {
        String name = this.doGetShortName();
        return this.myQualifier != null && (includeGlobalQualifier || this.myQualifier != GLOBAL) ? this.myQualifier.getCanonicalName(presentation, includeGlobalQualifier, context2, templateDepth) + "::" + name : name;
    }

    public String getShortName(int templateDepth) {
        return this.doGetShortName();
    }

    public String getNameWithParent() {
        String name = this.doGetShortName();
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.doGetShortName() + "::" + name : name;
    }

    public static OCQualifiedName parse(String qualifiedName) {
        OCQualifiedName result2 = null;
        for (String name : qualifiedName.split("::")) {
            result2 = OCQualifiedName.with(result2, name);
        }
        return result2;
    }

    public String toString() {
        String name = this.getShortName(0);
        return this.myQualifier != null && this.myQualifier != GLOBAL ? this.myQualifier.toString() + "::" + name : name;
    }

    public List<String> flatten() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result2.add(current.getName());
        }
        Collections.reverse(result2);
        return result2;
    }

    public List<Pair<String, List<OCTypeArgument>>> flattenWithArguments() {
        ArrayList<Pair<String, List<OCTypeArgument>>> result2 = new ArrayList<Pair<String, List<OCTypeArgument>>>();
        for (OCQualifiedName current = this; current != null; current = current.getQualifier()) {
            result2.add((Pair<String, List<OCTypeArgument>>)Pair.create((Object)current.getName(), current instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)current).getArguments() : null));
        }
        Collections.reverse(result2);
        return result2;
    }

    @Nullable
    public String getLeftmostQualifier() {
        return this.myQualifier == null ? this.myName : this.myQualifier.getLeftmostQualifier();
    }

    public OCQualifiedName cloneWithOffset(@NotNull OCSymbolReference reference) {
        return this.myQualifier != null ? new OCQualifiedName(this.myQualifier.cloneWithOffset(reference), this.myName) : this;
    }

    public int getDepth() {
        return (this.myQualifier != null ? this.myQualifier.getDepth() : 0) + 1;
    }
}

