/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.formatter.OCGoogleCodeStyle;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class OCLLVMCodeStyle
extends OCGoogleCodeStyle {
    public OCLLVMCodeStyle() {
        super("LLVM", "llvm");
    }

    public OCLLVMCodeStyle(@NotNull String name, @NotNull String id) {
        super(name, id);
    }

    @Override
    protected void customize(@NotNull CodeStyleSettings settings) {
        super.customize(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(OCLanguageUtils.getConfigLanguage());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        OCLLVMCodeStyle.applyNamingConvention(ocSettings);
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = false;
        commonSettings.INDENT_CASE_FROM_SWITCH = false;
        ocSettings.INDENT_VISIBILITY_KEYWORDS = 0;
        ocSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP = 1;
        ocSettings.TEMPLATE_DECLARATION_STRUCT_WRAP = 1;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 1;
        ocSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS = true;
    }

    private static void applyNamingConvention(@NotNull OCCodeStyleSettings settings) {
        settings.HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${PROJECT_REL_PATH}_${FILE_NAME}_${EXT}";
        settings.NAMING_CONVENTION_RULES = ContainerUtil.newArrayList((Object[])new NamingConventionRule[]{new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.MACRO), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.SCREAMING_SNAKE_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.NAMESPACE), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.SNAKE_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS, NamingConventionRule.EntityKind.ENUM, NamingConventionRule.EntityKind.UNION, NamingConventionRule.EntityKind.TYPEDEF), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.CLASS_MEMBER_FUNCTION, NamingConventionRule.EntityKind.STRUCT_MEMBER_FUNCTION, NamingConventionRule.EntityKind.GLOBAL_FUNCTION), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.CAMEL_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.ENUMERATOR), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.SCREAMING_SNAKE_CASE, ""), new NamingConventionRule(EnumSet.of(NamingConventionRule.EntityKind.LOCAL_VARIABLE, NamingConventionRule.EntityKind.PARAMETER, NamingConventionRule.EntityKind.GLOBAL_VARIABLE), EnumSet.of(NamingConventionRule.Visibility.ANY), EnumSet.of(NamingConventionRule.Specifier.ANY), "", NamingConventionStyle.PASCAL_CASE, "")});
    }
}

