/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCCppBaseClause;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSuperClassRef;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCUsageTypeProvider
implements UsageTypeProvider {
    public static final UsageType SUPER_CLASS = new UsageType(OCBundle.messagePointer("usage.superclass", new Object[0]));
    private static final UsageType PROTOCOL_LIST = new UsageType(OCBundle.messagePointer("usage.protocol", new Object[0]));
    private static final UsageType MESSAGE_RECEIVER = new UsageType(OCBundle.messagePointer("usage.message.receiver", new Object[0]));
    public static final UsageType QUALIFIER = new UsageType(OCBundle.messagePointer("usage.qualifier", new Object[0]));
    private static final UsageType MEMBER_ACCESS = new UsageType(OCBundle.messagePointer("usage.member.access", new Object[0]));
    public static final UsageType VARIABLE_DECLARATION = new UsageType(OCBundle.messagePointer("usage.variable.declaration", new Object[0]));
    public static final UsageType PARAMETER_DECLARATION = new UsageType(OCBundle.messagePointer("usage.parameter.declaration", new Object[0]));
    public static final UsageType DECLARATION_USAGES = new UsageType(OCBundle.messagePointer("usage.in.declaration", new Object[0]));
    public static final UsageType TEMPLATE_ARGUMENT_LIST_USAGES = new UsageType(OCBundle.messagePointer("usage.in.template.argument.list", new Object[0]));
    public static final UsageType METHOD_CALL = new UsageType(OCBundle.messagePointer("usage.method.call", new Object[0]));
    private static final UsageType PROPERTY_ATTRIBUTE = new UsageType(OCBundle.messagePointer("usage.in.property.attribute", new Object[0]));
    public static final UsageType SELECTOR_EXPRESSION = new UsageType(OCBundle.messagePointer("usage.selector.expression", new Object[0]));
    private static final UsageType SYNTHESIZE = new UsageType(OCBundle.messagePointer("usage.in.synthesize.statement", new Object[0]));
    private static final UsageType CLASS_PREDECLARATION = new UsageType(OCBundle.messagePointer("usage.class.predeclaration", new Object[0]));
    private static final UsageType PROTOCOL_PREDECLARATION = new UsageType(OCBundle.messagePointer("usage.protocol.predeclaration", new Object[0]));
    private static final UsageType NAMESPACE_QUALIFIER = new UsageType(OCBundle.messagePointer("usage.namespace.qualifier", new Object[0]));
    private static final UsageType INSIDE_USING_STATEMENT_USAGES = new UsageType(OCBundle.messagePointer("usage.in.using.statement", new Object[0]));
    private static final UsageType INSIDE_MACRO_SUBSTITUTION = new UsageType(OCBundle.messagePointer("usage.in.macro.substitution", new Object[0]));
    private static final UsageType INSIDE_MACRO_ARGUMENTS_USAGES = new UsageType(OCBundle.messagePointer("usage.in.macro.arguments.list", new Object[0]));
    private static final UsageType EXPRESSION_USAGES = new UsageType(OCBundle.messagePointer("usage.in.expression", new Object[0]));

    public UsageType getUsageType(@NotNull PsiElement element) {
        PsiElement superParent;
        PsiElement parent = element.getParent();
        PsiElement psiElement = superParent = parent != null ? parent.getParent() : null;
        if (OCTokenTypes.ALL_STRINGS.contains(OCElementUtil.getElementType(element))) {
            return UsageType.LITERAL_USAGE;
        }
        if (OCElementUtil.isPartOfMacroSubstitution(element)) {
            return INSIDE_MACRO_SUBSTITUTION;
        }
        if (element instanceof OCCppNamespaceQualifier || element instanceof OCCppNamespace) {
            return NAMESPACE_QUALIFIER;
        }
        if (element instanceof OCSendMessageExpression) {
            return METHOD_CALL;
        }
        if (element instanceof OCPropertyAttribute) {
            return PROPERTY_ATTRIBUTE;
        }
        if (element instanceof OCSelectorExpression) {
            return SELECTOR_EXPRESSION;
        }
        if (element instanceof OCIncludeDirective) {
            return UsageType.CLASS_IMPORT;
        }
        if (element instanceof OCClassPredeclaration) {
            return ((OCClassPredeclaration)element).isProtocol() ? PROTOCOL_PREDECLARATION : CLASS_PREDECLARATION;
        }
        if (element instanceof OCQualifiedExpression) {
            return MEMBER_ACCESS;
        }
        if (parent instanceof OCSuperClassRef || parent instanceof OCCppBaseClause) {
            return SUPER_CLASS;
        }
        if (parent instanceof OCProtocolList || parent instanceof OCReferenceElement) {
            return PROTOCOL_LIST;
        }
        if (superParent instanceof OCCastExpression) {
            return UsageType.CLASS_CAST_TO;
        }
        if (parent instanceof OCSynthesizeProperty) {
            return SYNTHESIZE;
        }
        if (parent instanceof OCReferenceExpression) {
            if (Registry.is((String)"cidr.find.usages.type.expressions.as.value.read.write")) {
                return null;
            }
            if (superParent instanceof OCSendMessageExpression) {
                return MESSAGE_RECEIVER;
            }
            if (superParent instanceof OCQualifiedExpression) {
                return QUALIFIER;
            }
            if (superParent instanceof OCExpression) {
                return EXPRESSION_USAGES;
            }
        }
        if (parent instanceof OCTypeElement) {
            if (superParent instanceof OCMethod) {
                return UsageType.CLASS_METHOD_RETURN_TYPE;
            }
            if (superParent instanceof OCMethodSelectorPart || superParent instanceof OCParameterDeclaration) {
                return PARAMETER_DECLARATION;
            }
            if (superParent instanceof OCDeclaration) {
                return VARIABLE_DECLARATION;
            }
        }
        if (element instanceof OCDeclarator || element instanceof OCMethod || element instanceof OCReferenceElement && parent instanceof OCNamespaceQualifierOwner) {
            return DECLARATION_USAGES;
        }
        if (element instanceof OCReferenceElement && parent instanceof OCTypeElement && superParent instanceof OCTemplateArgumentList) {
            return TEMPLATE_ARGUMENT_LIST_USAGES;
        }
        if (element instanceof OCReferenceElement && parent instanceof OCCppUsingStatement) {
            return INSIDE_USING_STATEMENT_USAGES;
        }
        if (PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, _parent -> _parent instanceof OCMacroCallArgument) != null) {
            return INSIDE_MACRO_ARGUMENTS_USAGES;
        }
        return null;
    }
}

