/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCIncludeHelpers;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCFileReferenceHelper
extends FileReferenceHelper {
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        return file2.getFileType() == OCFileType.INSTANCE;
    }

    @NotNull
    public String trimUrl(@NotNull String url) {
        return url.trim();
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile file2) {
        OCResolveRootAndConfiguration rootAndConfig;
        OCResolveConfiguration configuration;
        ArrayList<PsiFileSystemItem> roots2 = new ArrayList<PsiFileSystemItem>();
        PsiFileSystemItem item = this.getPsiFileSystemItem(project2, file2);
        if (item != null) {
            ContainerUtil.addIfNotNull(roots2, (Object)item.getParent());
        }
        if ((configuration = (rootAndConfig = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(file2, project2)).getConfiguration()) != null) {
            OCCompilerSettings compilerSettings = configuration.getCompilerSettings(rootAndConfig.getKind(), rootAndConfig.getRootFile());
            for (PsiFileSystemItem psiFileSystemItem : compilerSettings.getHeadersSearchRoots().getAllRoots()) {
                if (!psiFileSystemItem.isValid()) continue;
                roots2.add(psiFileSystemItem);
            }
        }
        OCIncludeHelpers.processContainingFramework(project2, file2, (Processor<PsiFileSystemItem>)new CommonProcessors.CollectProcessor(roots2));
        return roots2;
    }
}

