/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.OCExprSymbolClassifier;
import com.jetbrains.cidr.lang.resolve.OCPsiExprClassifierVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCValueCategoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCExprValueCategory {
    LValue,
    PRValue,
    XValue;


    public boolean isLValue() {
        return this == LValue;
    }

    public boolean isRValue() {
        return this == PRValue || this == XValue;
    }

    public boolean isGLValue() {
        return this == LValue || this == XValue;
    }

    @NotNull
    public static OCExprValueCategory classify(@Nullable OCExpression expr) {
        return expr == null ? PRValue : OCExprValueCategory.classify(expr, OCResolveContext.forPsi(expr));
    }

    @NotNull
    public static OCExprValueCategory classify(@Nullable OCTypeOwner expr, @NotNull OCResolveContext context2) {
        return OCExprValueCategory.classify(expr, null, context2);
    }

    @NotNull
    public static OCExprValueCategory classify(@Nullable OCTypeOwner expr, @Nullable OCType exprType, @NotNull OCResolveContext context2) {
        if (expr instanceof OCExpression) {
            OCPsiExprClassifierVisitor visitor = new OCPsiExprClassifierVisitor(context2);
            ((OCExpression)expr).accept(visitor);
            return visitor.getResult();
        }
        if (expr instanceof OCExpressionSymbol) {
            return new OCExprSymbolClassifier(context2).classify((OCExpressionSymbol)expr, exprType);
        }
        if (expr instanceof OCValueCategoryHolder) {
            return ((OCValueCategoryHolder)expr).getCategory();
        }
        return PRValue;
    }

    @NotNull
    public static OCExprValueCategory byReturnType(@NotNull OCType type) {
        if (type instanceof OCCppReferenceType) {
            return ((OCCppReferenceType)type).isRvalueRef() ? XValue : LValue;
        }
        return PRValue;
    }
}

