/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCompilerGeneratedConstructorSymbol
extends OCCompilerGeneratedFunctionSymbol {
    public OCCompilerGeneratedConstructorSymbol(@NotNull OCStructSymbol struct, @NotNull List<OCDeclaratorSymbol> parameterSymbols) {
        super(struct, struct.getName(), struct.getType(), struct.getTemplateParameters(), parameterSymbols.stream().map(s -> OCCompilerGeneratedConstructorSymbol.createParameterSymbol(s.getType(), s.getInitializerExpression())).collect(Collectors.toList()), OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
    }

    public OCCompilerGeneratedConstructorSymbol(@NotNull OCStructSymbol struct, @NotNull Kind kind, @NotNull Project project2) {
        super(struct, (kind == Kind.DefaultDtor ? "~" : "") + struct.getName(), struct.getType(), struct.getTemplateParameters(), OCCompilerGeneratedConstructorSymbol.requireParameter(kind) ? Collections.singletonList(OCCompilerGeneratedConstructorSymbol.createParameterSymbol(OCCompilerGeneratedConstructorSymbol.getParamType(struct, kind, project2), null)) : Collections.emptyList(), OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
    }

    private static boolean requireParameter(@NotNull Kind kind) {
        return kind != Kind.DefaultCtor && kind != Kind.DefaultDtor;
    }

    private static OCDeclaratorSymbol createParameterSymbol(@NotNull OCType type, @Nullable OCExpressionSymbol initializer) {
        return new OCDeclaratorSymbolImpl(null, Long.MAX_VALUE, null, OCQualifiedName.interned("<unnamed>"), Collections.emptyList(), type, OCSymbolKind.PARAMETER, initializer, Collections.emptyList(), Collections.emptyList(), OCDeclaratorSymbol.Property.IS_SYNTHETIC.ordinal(), 0, null, null);
    }

    private static OCType getParamType(@NotNull OCStructSymbol struct, @NotNull Kind kind, @NotNull Project project2) {
        switch (kind) {
            case CopyCtor: {
                return OCCppReferenceType.to(struct.getType().cloneWithConstModifier(project2), false, false, false);
            }
            case MoveCtor: {
                return OCCppReferenceType.rvalue(struct.getType());
            }
        }
        throw new UnsupportedOperationException("No parameter type for " + (Object)((Object)kind));
    }

    public static enum Kind {
        DefaultCtor,
        DefaultDtor,
        CopyCtor,
        MoveCtor;

    }
}

