/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.introduce;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.intentions.OCGeneratePropertyIntentionAction;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCChangeVisibilityIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseExpressionInplaceIntroducer;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseLocalConvertibleHandler;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIvarInplaceIntroducer
extends OCBaseExpressionInplaceIntroducer<OCDeclarator, PsiElement> {
    private JCheckBox mySynthesizeCB;
    protected JCheckBox myDeclareInInterfaceCb;

    public OCIvarInplaceIntroducer(Project project2, Editor editor, PsiElement expression, List<PsiElement> occurrences, String refactoringName) {
        super(project2, editor, expression, occurrences, OCDeclarator.class, PsiElement.class, refactoringName);
    }

    @Override
    public void configurePanel() {
        super.configurePanel();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)this.myEditor).getCustomSettings(OCCodeStyleSettings.class);
        if (this.askToGenerateProperty()) {
            this.mySynthesizeCB = this.createCheckBox("Generate &property", settings.INTRODUCE_GENERATE_PROPERTY, () -> {
                settings.INTRODUCE_GENERATE_PROPERTY = this.mySynthesizeCB.isSelected();
            });
        }
        if (OCCompilerFeaturesHelper.supportsIvarsInImplementation()) {
            this.myDeclareInInterfaceCb = this.createCheckBox("Declare in the &interface", !settings.PUT_IVARS_TO_IMPLEMENTATION, null);
        }
    }

    protected boolean askToGenerateProperty() {
        return !(this.myExpr instanceof OCSynthesizeProperty);
    }

    @Override
    protected OCSymbolKind getDeclaratorKind() {
        return OCSymbolKind.INSTANCE_VARIABLE;
    }

    @Override
    protected String checkExpression(PsiElement expression) {
        String message = super.checkExpression(expression);
        if (message != null) {
            return message;
        }
        if (this.myParentSymbol == null) {
            OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getContextOfType((PsiElement)this.myExpr, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
            OCMethod method = (OCMethod)PsiTreeUtil.getContextOfType((PsiElement)block, (boolean)false, (Class[])new Class[]{OCMethod.class});
            if (method == null || !method.isInstanceMethod()) {
                return "Selected expression should be inside an instance method";
            }
            OCClassDeclaration classDecl = (OCClassDeclaration)PsiTreeUtil.getParentOfType((PsiElement)method, OCClassDeclaration.class);
            this.myParentSymbol = classDecl != null ? classDecl.getSymbol() : null;
        }
        return null;
    }

    @Override
    public PsiElement evaluateAnchor() {
        if (this.myExpr instanceof OCSynthesizeProperty) {
            return this.myExpr.getPrevSibling();
        }
        return super.evaluateAnchor();
    }

    @Override
    protected String[] suggestNames(boolean replaceAll, @Nullable OCDeclarator variable) {
        if (this.myUsageName != null) {
            return new String[]{this.myUsageName};
        }
        String[] names = super.suggestNames(replaceAll, variable);
        for (int i2 = 0; i2 < names.length; ++i2) {
            names[i2] = OCNameSuggester.getNonCollidingName(names[i2], OCSymbolKind.PROPERTY, true, this.myProject);
        }
        return names;
    }

    private OCDeclarator addIvar(String name, PsiElement mainExpression, OCClassDeclaration clazz, PsiElement anchor, boolean previewMode) {
        String modifier = null;
        PsiElement initializer = mainExpression;
        if (mainExpression instanceof OCSynthesizeProperty) {
            OCPropertySymbol propertySymbol;
            OCReferenceElement propertyRef = ((OCSynthesizeProperty)mainExpression).getPropertyRef();
            OCPropertySymbol oCPropertySymbol = propertySymbol = propertyRef != null ? (OCPropertySymbol)propertyRef.resolveToSymbol() : null;
            if (propertySymbol != null && OCCompilerFeaturesHelper.isArcEnabled(mainExpression.getContainingFile())) {
                ARCAttribute ivarAttribute;
                OCType type = propertySymbol.getResolvedType(OCResolveContext.forPsi(mainExpression));
                OCPropertySymbol.FlagAttribute propAttribute = propertySymbol.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, mainExpression);
                if (type.isPointerToObjectCompatible() && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
            }
        } else if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(mainExpression)) {
            initializer = ((OCDeclarator)mainExpression.getParent()).getInitializer();
        }
        OCDeclaration declaration = OCElementFactory.declaration(modifier, name, this.myExprType, mainExpression);
        declaration = OCChangeUtil.add(clazz.getInstanceVariablesList(), declaration);
        if (!this.isCreateFromUsageMode() && initializer != null) {
            OCStatement statement2 = OCElementFactory.statementFromText(name + "=a;", (PsiElement)mainExpression.getContainingFile(), true);
            OCExpression source = ((OCAssignmentExpression)((OCExpressionStatement)statement2).getExpression()).getSourceExpression();
            if (previewMode) {
                source.replace(initializer);
            } else {
                OCChangeUtil.replaceHandlingMacros(source, initializer);
            }
            anchor = this.ensureParentIsBlockStatement(anchor);
            if (mainExpression.getParent() instanceof OCExpressionStatement || OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(mainExpression)) {
                OCStatement parentStmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)(mainExpression.isValid() ? mainExpression : anchor), OCStatement.class, (boolean)false);
                statement2 = (OCStatement)OCChangeUtil.replaceHandlingMacros(parentStmt, statement2);
            } else {
                statement2 = OCChangeUtil.addBefore(anchor.getParent(), statement2, anchor);
            }
            if (previewMode) {
                OCExpression extraOccurrence = ((OCAssignmentExpression)((OCExpressionStatement)statement2).getExpression()).getReceiverExpression();
                this.addOccurrence(extraOccurrence);
                if (!this.myExpr.isValid()) {
                    this.myExpr = extraOccurrence;
                    this.myExprMarker = this.createMarker(this.myExpr);
                }
            }
        }
        return declaration.getDeclarators().get(0);
    }

    @Override
    protected void introduceForPreview(String name) {
        Object mainExpression = this.getMainExpression();
        PsiElement anchor = this.getAnchor();
        PsiElement parent = PsiTreeUtil.getContextOfType((PsiElement)anchor, (boolean)false, (Class[])new Class[]{OCImplementation.class, PsiFile.class});
        if (parent instanceof PsiFile) {
            OCInterface clazz = OCElementFactory.interfaceByName("i", anchor);
            parent = parent.add((PsiElement)clazz);
        }
        OCDeclarator declarator = this.addIvar(name, (PsiElement)mainExpression, (OCClassDeclaration)parent, anchor, true);
        this.setVariable(declarator);
    }

    @Override
    protected void introduceForReal(String name) {
        OCSymbol ivarSymbol;
        OCClassDeclaration<?> parent;
        OCClassSymbol classSymbol;
        OCClassDeclaration<?> anchor = this.getAnchor();
        OCClassDeclaration<?> parentClass = (OCClassDeclaration<?>)PsiTreeUtil.getContextOfType((PsiElement)anchor, (boolean)false, (Class[])new Class[]{OCImplementation.class});
        if (this.myParentSymbol instanceof OCClassSymbol) {
            classSymbol = (OCClassSymbol)this.myParentSymbol;
        } else {
            OCClassSymbol oCClassSymbol = classSymbol = parentClass != null ? parentClass.getSymbol() : null;
        }
        if (classSymbol == null) {
            return;
        }
        OCClassSymbol parentSymbol = classSymbol.getInterface(this.myProject);
        OCImplementationSymbol implementationSymbol = classSymbol.getImplementation(this.myProject);
        if (OCCompilerFeaturesHelper.supportsIvarsInImplementation() && !this.myDeclareInInterfaceCb.isSelected() && implementationSymbol != null && parentClass != null && Comparing.equal((Object)implementationSymbol, (Object)parentClass.getSymbol())) {
            parentSymbol = implementationSymbol;
        }
        if ((parent = OCElementUtil.resolveClassDeclaration(parentSymbol, this.myProject)) == null || !CommonRefactoringUtil.checkReadOnlyStatus(parent)) {
            return;
        }
        Object mainExpression = this.getMainExpression();
        OCDeclarator declarator = this.addIvar(name, (PsiElement)mainExpression, parent, anchor, false);
        OCImportSymbolFix.fixAllSymbolsRecursively(declarator.getParent());
        if (this.changeUsages(name)) {
            for (PsiElement occurrence : this.myOccurrences) {
                if (!occurrence.isValid()) continue;
                if (OCBaseLocalConvertibleHandler.isDeclaratorIdentifier(occurrence)) {
                    OCChangeUtil.delete(occurrence.getParent());
                    continue;
                }
                OCChangeUtil.replaceHandlingMacros(occurrence, OCElementFactory.expressionFromText(name, occurrence));
            }
        }
        if (this.mySynthesizeCB != null && this.mySynthesizeCB.isSelected() && (ivarSymbol = declarator.getSymbol()) instanceof OCInstanceVariableSymbol) {
            this.performIntentionAction(new OCGeneratePropertyIntentionAction(){

                @Override
                protected OCInstanceVariableSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file2) {
                    return (OCInstanceVariableSymbol)ivarSymbol;
                }
            }, declarator.getContainingFile());
            OCInstanceVariableSymbol ivar = (OCInstanceVariableSymbol)declarator.getSymbol();
            if (!anchor.isValid()) {
                OCClassDeclaration<?> oCClassDeclaration = anchor = parentClass != null ? parentClass : parent;
            }
            if (ivar != null && !OCVisibility.isVisible(ivar, anchor, null, this.myProject)) {
                OCVisibility visibility = OCVisibility.getMinimalVisibilityForSymbolToBeAccessible(ivar, anchor, null);
                this.performIntentionAction(new OCChangeVisibilityIntentionAction(ivar, visibility, OCCompilationContext.create(declarator)), declarator.getContainingFile());
            }
        }
    }

    @Override
    @NotNull
    protected String getFeatureID() {
        return "refactoring.appCodeIntroduceVariable";
    }

    private void performIntentionAction(IntentionAction action, PsiFile file2) {
        if (action.isAvailable(this.myProject, this.myEditor, file2)) {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
            action.invoke(this.myProject, this.myEditor, file2);
        }
    }

    @Override
    public PsiElement getPreviewElement(OCDeclarator element) {
        return element.getParent();
    }
}

