/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.impl.OCPsiFileBaseImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileImpl
extends OCPsiFileBaseImpl
implements OCFile {
    private int myAnnotationSessionDepthsCounter = 0;
    private AnnotationSession myCurrentAnnotationSession = null;
    private final Object myAnnotationSessionLock = new Object();
    private final Set<VirtualFile> myIncludedFrom = new THashSet();
    @Nullable
    private volatile FileSymbolTable mySymbolTableCache;
    @Nullable
    private volatile OCParsedLanguageAndConfiguration myParsedLanguageAndConfiguration;

    public OCFileImpl(FileViewProvider viewProvider) {
        super(viewProvider, OCLanguageUtils.getSlowLanguage());
    }

    @Override
    @NotNull
    public FileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @Override
    @NotNull
    public OCFile getOCFile() {
        return this;
    }

    @Override
    @NotNull
    public PsiElement asElementFromOCFile(@NotNull PsiElement psiElementFromThisFile) {
        assert (psiElementFromThisFile.getContainingFile() == this);
        return psiElementFromThisFile;
    }

    public PsiElement findElementAt(int offset) {
        return this.getViewProvider().findElementAt(offset, OCLanguageUtils.getSlowLanguage());
    }

    public void subtreeChanged() {
        super.subtreeChanged();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFile() {
        class StopException
        extends RuntimeException {
            StopException() {
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)this.getName());
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        final OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{file2 -> FileUtilRt.getNameWithoutExtension((String)file2.getName()).equals(nameWithoutExtension), Conditions.alwaysTrue()});
        try {
            this.accept(new OCRecursiveVisitor(){

                @Override
                public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
                    this.processSymbol(declaration.getSymbol());
                    super.visitFunctionDeclaration(declaration);
                }

                @Override
                public void visitFunctionDefinition(OCFunctionDefinition definition) {
                    this.processSymbol(definition.getSymbol());
                    super.visitFunctionDefinition(definition);
                }

                @Override
                public void visitClassDeclaration(OCClassDeclaration dcl) {
                    this.processSymbol(dcl.getSymbol());
                    super.visitClassDeclaration(dcl);
                }

                private void processSymbol(OCSymbol symbol) {
                    if (symbol != null) {
                        symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                            OCFile file2 = symbol1.getContainingOCFile(OCFileImpl.this.getProject());
                            if (file2 != null && file2.isHeader() != OCFileImpl.this.isHeader() && !processor2.process(file2)) {
                                throw new StopException();
                            }
                            return true;
                        }), OCFileImpl.this.getProject());
                    }
                }
            });
        }
        catch (StopException stopException) {
            // empty catch block
        }
        processor2.finish();
        if (finder.isFound()) {
            return (OCFile)finder.getFoundValue();
        }
        return this.getAssociatedFileWithSameName();
    }

    @Override
    @Nullable
    public OCFile getAssociatedFileWithSameName() {
        VirtualFile virtualFile = this.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        Project project2 = this.getProject();
        VirtualFile associated = OCSearchUtil.getAssociatedFileWithSameName(project2, virtualFile);
        if (associated != null) {
            PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(associated);
            return file2 instanceof OCFile ? (OCFile)file2 : null;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this.getKind().isCpp();
    }

    @Override
    public void clearCaches() {
        this.mySymbolTableCache = null;
        super.clearCaches();
    }

    @Override
    public boolean processSymbolsRecursively(@NotNull Processor<OCSymbol> processor2) {
        return this.processSymbolsRecursively(null, processor2);
    }

    public boolean processSymbolsRecursively(@Nullable OCImmutableInclusionContext inclusionContext, final @NotNull Processor<OCSymbol> processor2) {
        PsiElement context2 = this.getContext();
        if (context2 instanceof OCElement && !((OCElement)context2).getContainingOCFile().processSymbolsRecursively(processor2)) {
            return false;
        }
        FileSymbolTable table = this.getSymbolTable(inclusionContext == null ? null : inclusionContext.derive());
        return table == null || table.shallowProcessSymbols((Processor<? super OCSymbol>)new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                if (!processor2.process((Object)symbol)) {
                    return false;
                }
                if (symbol instanceof OCMembersContainer) {
                    return ((OCMembersContainer)((Object)symbol)).processMembers(null, this);
                }
                return true;
            }
        });
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull OCElement element, @NotNull Class<T> symbolClass) {
        PsiFile containingFile;
        PsiElement context2 = this.getContext();
        if (context2 != null && (containingFile = context2.getContainingFile()) instanceof OCFile) {
            return ((OCFile)containingFile).findSymbol(element, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(element, symbolClass) : null;
    }

    @Override
    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String name, Class<T> symbolClass) {
        PsiElement context2 = this.getContext();
        if (context2 instanceof OCElement) {
            return ((OCElement)context2).getContainingOCFile().findSymbol(name, symbolClass);
        }
        FileSymbolTable table = this.getSymbolTable(null);
        return table != null ? (T)table.findSymbol(name, symbolClass) : null;
    }

    @Nullable
    public FileSymbolTable getSymbolTable(@Nullable OCInclusionContext context2) {
        if (context2 != null) {
            return FileSymbolTable.forFile(this, context2);
        }
        FileSymbolTable result2 = this.mySymbolTableCache;
        if (result2 == null || !result2.isValid()) {
            this.mySymbolTableCache = result2 = FileSymbolTable.forFile(this, OCInclusionContextUtil.headerContext(this).derive());
        }
        return result2;
    }

    @Override
    @NotNull
    public OCNamespaceLikeSymbol getMembersContainer(boolean onlyTypes) {
        OCFileGlobalSymbolsCache cache = OCFileGlobalSymbolsCache.getInstance(this.getProject());
        return onlyTypes ? cache.typesOnlyTableForFile(this) : cache.lightTableForFile(this);
    }

    @Override
    @Nullable
    public OCSymbol getSameNamedClass() {
        final String name = this.getMainClassName();
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return (symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && !((OCStructSymbol)symbol).isInnerClass()) && name.equals(symbol.getName());
            }
        };
        this.processSymbolsRecursively((Processor<OCSymbol>)finder);
        return (OCSymbol)finder.getFoundValue();
    }

    @Override
    public String getMainClassName() {
        int minus;
        String name = FileUtilRt.getNameWithoutExtension((String)this.getName());
        int plus = name.indexOf(43);
        if (plus != -1) {
            name = name.substring(0, plus);
        }
        if ((minus = name.indexOf(45)) != -1) {
            name = name.substring(0, minus);
        }
        return name;
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findFirstClass() {
        return this.findClass(null);
    }

    @Override
    @Nullable
    public OCSymbolDeclarator findClass(final String name) {
        final Ref result2 = new Ref();
        this.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (!(dcl instanceof OCClassPredeclaration) && result2.isNull() && (name == null || name.equals(dcl.getCanonicalName()))) {
                    result2.set((Object)dcl);
                }
                super.visitClassDeclaration(dcl);
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (result2.isNull() && (name == null || name.equals(struct.getName()))) {
                    result2.set((Object)struct);
                }
                super.visitStruct(struct);
            }
        });
        return (OCSymbolDeclarator)result2.get();
    }

    @Override
    public List<OCIncludeDirective> findIncludeDirectives() {
        final ArrayList<OCIncludeDirective> answer = new ArrayList<OCIncludeDirective>();
        this.acceptChildren(new OCRecursiveVisitor(){

            @Override
            public void visitImportDirective(OCIncludeDirective directive) {
                answer.add(directive);
            }
        });
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushAnnotationSession(AnnotationSession session) {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = session;
            }
            ++this.myAnnotationSessionDepthsCounter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void popAnnotationSession() {
        Object object = this.myAnnotationSessionLock;
        synchronized (object) {
            --this.myAnnotationSessionDepthsCounter;
            if (this.myAnnotationSessionDepthsCounter == 0) {
                this.myCurrentAnnotationSession = null;
            }
        }
    }

    @Override
    @Nullable
    public AnnotationSession getCurrentAnnotationSession() {
        return this.myCurrentAnnotationSession;
    }

    @Override
    @NotNull
    public Object getAnnotationSessionLock() {
        return this.myAnnotationSessionLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markIncludedFrom(VirtualFile from) {
        if (OCInclusionContextUtil.isLongLived(from)) {
            Set<VirtualFile> set = this.myIncludedFrom;
            synchronized (set) {
                this.myIncludedFrom.add(from);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualFile> resetIncludingFiles() {
        Set<VirtualFile> set = this.myIncludedFrom;
        synchronized (set) {
            ArrayList<VirtualFile> answer = new ArrayList<VirtualFile>(this.myIncludedFrom);
            this.myIncludedFrom.clear();
            return answer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<VirtualFile> getIncludingFiles() {
        Set<VirtualFile> set = this.myIncludedFrom;
        synchronized (set) {
            return new ArrayList<VirtualFile>(this.myIncludedFrom);
        }
    }

    @Override
    @Nullable
    public OCIncludeDirective findIncludeDirective(@Nullable VirtualFile file2) {
        if (!OCInclusionContextUtil.isLongLived(file2)) {
            return null;
        }
        for (PsiElement child : this.getChildren()) {
            OCIncludeDirective directive;
            PsiFile importedFile;
            if (!(child instanceof OCIncludeDirective) || !Comparing.equal((Object)file2, (Object)OCElementUtil.getFilePath(importedFile = (directive = (OCIncludeDirective)child).getIncludedFile()))) continue;
            return directive;
        }
        return null;
    }

    public String toString() {
        return "OCFile:" + this.getName();
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof OCVisitor) {
            ((OCVisitor)visitor).visitOCFile(this);
        } else {
            visitor.visitFile((PsiFile)this);
        }
    }

    public void setOriginalFile(@NotNull PsiFile originalFile) {
        OCLog.LOG.assertTrue(originalFile instanceof OCFile);
        super.setOriginalFile(originalFile);
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        return this.getTextRange();
    }

    @Override
    public OCFile getContainingOCFile() {
        return this;
    }

    @Override
    public String getTextWithMacros() {
        return this.getText();
    }

    @Override
    public boolean isEmpty() {
        for (PsiElement child : this.getChildren()) {
            if (child instanceof OCDefineDirective || child instanceof OCMacroCall) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getComplexOffset() {
        return this.getTextOffset();
    }

    @Override
    public boolean hasExtraTopLevelDefinitions() {
        OCSymbol mainClass = this.getSameNamedClass();
        if (mainClass == null) {
            return false;
        }
        for (PsiElement child : this.getChildren()) {
            OCType type;
            if (child instanceof OCClassDeclaration && ((OCClassDeclaration)child).getSymbol() != mainClass) {
                return true;
            }
            if (!(child instanceof OCDeclaration) || (type = ((OCDeclaration)child).getType()) instanceof OCStructType && ((OCStructType)type).getSymbol().equals(mainClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public OCParsedLanguageAndConfiguration getParsedLanguageAndConfiguration() {
        return this.myParsedLanguageAndConfiguration;
    }

    public void setParsedLanguageAndConfiguration(@Nullable OCParsedLanguageAndConfiguration languageAndConfiguration) {
        this.myParsedLanguageAndConfiguration = languageAndConfiguration;
    }
}

