/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.navigation.OCSymbolPresentation;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCElementBase
extends ASTWrapperPsiElement
implements OCElement {
    protected static final String EMPTY_NAME = "";
    private static final TokenSet SYMBOL_NAME_STARTERS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.POSSIBLE_ID_NAMES, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.THIS_CPP_KEYWORD})});
    private static final TokenSet CPP_OPERATOR_SYMBOL_NAME_PARTS = TokenSet.orSet((TokenSet[])new TokenSet[]{OCTokenTypes.POSSIBLE_ID_NAMES, OCTokenTypes.OVERLOADED_CPP_OPERATORS, TokenSet.create((IElementType[])new IElementType[]{OCElementTypes.TYPE_ELEMENT})});

    public OCElementBase(@NotNull ASTNode node2) {
        super(node2);
    }

    @NotNull
    public Language getLanguage() {
        return OCLanguageUtils.getSlowLanguage();
    }

    public String toString() {
        return OCElementUtil.getElementDebugName(this);
    }

    @Override
    public OCFile getContainingOCFile() {
        return (OCFile)super.getContainingFile();
    }

    protected Icon getBaseIcon() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.getBaseIcon() : super.getBaseIcon();
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? symbol.computeFullIconNow(this, this.getProject()) : super.getElementIcon(flags);
    }

    public ItemPresentation getPresentation() {
        OCSymbol symbol = this.getElementSymbolIfAny();
        return symbol != null ? new OCSymbolPresentation(symbol, this.getProject()) : super.getPresentation();
    }

    @Nullable
    private OCSymbol getElementSymbolIfAny() {
        return this instanceof OCSymbolDeclarator ? (OCSymbol)((OCSymbolDeclarator)((Object)this)).getSymbol() : null;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof OCVisitor) {
            this.accept((OCVisitor)visitor);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitOCElement(this);
    }

    @Override
    @NotNull
    public String getTextWithMacros() {
        return OCElementUtil.getTextWithMacros(this);
    }

    @Override
    @NotNull
    public TextRange getRangeWithMacros() {
        return OCElementUtil.getRangeWithMacros(this);
    }

    @Override
    public boolean isEmpty() {
        return OCElementUtil.isElementEmpty(this);
    }

    public PsiReference findReferenceAt(int offset) {
        PsiReference refInMacro = OCElementUtil.findReferenceInMacro(this.findElementAt(offset));
        return refInMacro != null ? refInMacro : super.findReferenceAt(offset);
    }

    @NotNull
    public SearchScope getUseScope() {
        return OCScopeInfo.createScopeInfo(this).getSearchScope();
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        OCChangeUtil.delete(child.getPsi());
    }

    @Override
    public long getComplexOffset() {
        return OCSymbolOffsetUtil.getComplexOffset(this);
    }

    @Nullable
    protected PsiElement findReferenceTokenInCall() {
        return this.findChildByType(SYMBOL_NAME_STARTERS);
    }

    @Nullable
    protected PsiElement findNameStartTokenInCall() {
        PsiElement id = this.findReferenceTokenInCall();
        return OCElementUtil.getElementType(id) == OCTokenTypes.OPERATOR_CPP_KEYWORD ? OCElementBase.getNameIdentifierInOperator(id) : id;
    }

    protected TextRange getRangeInCallElement() {
        PsiElement child = this.findReferenceTokenInCall();
        if (child != null) {
            TextRange parentRange = OCElementBase.getRange(this);
            if (TextRange.EMPTY_RANGE.equals((Object)parentRange)) {
                return TextRange.EMPTY_RANGE;
            }
            int parentStartOffset = parentRange.getStartOffset();
            if (OCElementUtil.getElementType(child) == OCTokenTypes.OPERATOR_CPP_KEYWORD) {
                TextRange endName;
                PsiElement startNameToken = OCElementBase.getNameIdentifierInOperator(child);
                TextRange startName = OCElementBase.getRange(startNameToken);
                if (TextRange.EMPTY_RANGE.equals((Object)startName)) {
                    return TextRange.EMPTY_RANGE;
                }
                PsiElement endNameToken = child.getParent().getLastChild();
                if (startNameToken == endNameToken || TextRange.EMPTY_RANGE.equals((Object)(endName = OCElementBase.getRange(endNameToken)))) {
                    return startName.shiftRight(-parentStartOffset);
                }
                return TextRange.create((int)startName.getStartOffset(), (int)endName.getEndOffset()).shiftRight(-parentStartOffset);
            }
            PsiElement maybeTilde = PsiTreeUtil.skipWhitespacesBackward((PsiElement)child);
            if (OCElementUtil.getElementType(maybeTilde) == OCTokenTypes.TILDE) {
                return TextRange.create((int)OCElementBase.getRange(maybeTilde).getStartOffset(), (int)OCElementBase.getRange(child).getEndOffset()).shiftRight(-parentStartOffset);
            }
            TextRange range = OCElementBase.getRange(child);
            if (!TextRange.EMPTY_RANGE.equals((Object)range)) {
                return range.shiftRight(-parentStartOffset);
            }
        }
        return TextRange.EMPTY_RANGE;
    }

    @Contract(value="null -> null")
    private static PsiElement getNameIdentifierInOperator(@Nullable PsiElement psiOperatorKeyword) {
        if (psiOperatorKeyword == null) {
            return null;
        }
        return OCElementUtil.getNextSiblingOfAnyType(psiOperatorKeyword, CPP_OPERATOR_SYMBOL_NAME_PARTS);
    }

    @NotNull
    @Contract(pure=true)
    private static TextRange getRange(@Nullable PsiElement element) {
        if (element == null) {
            return TextRange.EMPTY_RANGE;
        }
        if (!OCElementUtil.isElementEmpty(element)) {
            return element.getTextRange();
        }
        if (!(element instanceof LeafElement)) {
            element = PsiTreeUtil.getDeepestFirst((PsiElement)element);
        }
        if (element instanceof OCMacroForeignLeafElement) {
            return element.getTextRange();
        }
        return TextRange.EMPTY_RANGE;
    }
}

