/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.impl.OCElementBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;

public class OCDirectiveImpl
extends OCElementBase
implements OCDirective {
    public OCDirectiveImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @NotNull
    public PsiElement getHeaderToken() {
        return this.getFirstChild();
    }

    @Override
    @NotNull
    public Pair<String, TextRange> getContent(boolean unescapeAndTrim) {
        return this.getContent(this.getHeaderToken(), unescapeAndTrim);
    }

    @Override
    @NotNull
    public Pair<String, TextRange> getContent(@NotNull PsiElement headerToken, boolean unescapeAndTrim) {
        int start = -1;
        int end = -1;
        StringBuilder context2 = new StringBuilder();
        PsiElement contentToken = headerToken.getNextSibling();
        StringBuilder middleWS = new StringBuilder();
        while (contentToken != null) {
            if (!(contentToken instanceof ForeignLeafPsiElement)) {
                IElementType type = OCElementUtil.getElementType(contentToken);
                boolean skipToTrim = unescapeAndTrim && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type);
                TextRange contentTokenTextRange = contentToken.getTextRange();
                if (start < 0) {
                    if (skipToTrim) {
                        contentToken = contentToken.getNextSibling();
                        continue;
                    }
                    start = contentTokenTextRange.getStartOffset();
                }
                if (!skipToTrim) {
                    end = contentTokenTextRange.getEndOffset();
                    if (middleWS.length() > 0) {
                        context2.append((CharSequence)middleWS);
                        middleWS = new StringBuilder();
                    }
                    context2.append(contentToken.getText());
                } else if (OCTokenTypes.COMMENTS.contains(type)) {
                    middleWS.append(' ');
                } else if (type != OCTokenTypes.EOL_ESCAPE) {
                    middleWS.append(contentToken.getText());
                }
            }
            contentToken = contentToken.getNextSibling();
        }
        return Pair.create((Object)context2.toString(), (Object)(start < 0 ? TextRange.create((int)headerToken.getTextRange().getEndOffset(), (int)headerToken.getTextRange().getEndOffset()) : TextRange.create((int)start, (int)end)));
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitDirective(this);
    }
}

