/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBinaryExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCBinaryExpression {
    public OCBinaryExpressionImpl(@NotNull ASTNode node2) {
        super(node2);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        String name = this.getOperationSign().getName();
        OCExpression left = this.getLeft();
        OCExpression right = this.getRight();
        if (left != null && right != null) {
            return new OCOperatorReference((PsiElement)this, name, OCOperatorReference.OperatorPlacement.INFIX, this.getOperationSignNode().getPsi(), left, right);
        }
        return null;
    }

    @Override
    @Nullable
    public OCExpression getLeft() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    public OCExpression getRight() {
        boolean passedSign = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt instanceof OCPunctuatorElementType) {
                passedSign = true;
                continue;
            }
            if (!passedSign || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Override
    @NotNull
    public ASTNode getOperationSignNode() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (!(tt instanceof OCPunctuatorElementType)) continue;
            return child;
        }
        throw new AssertionError((Object)("Cannot find operation sign in binary expression: " + this.getText()));
    }

    @Override
    @NotNull
    public OCElementType getOperationSign() {
        return (OCElementType)this.getOperationSignNode().getElementType();
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        visitor.visitBinaryExpression(this);
    }

    @Override
    @NotNull
    protected OCType getType(@NotNull OCResolveContext context2) {
        OCOperatorReference reference = (OCOperatorReference)this.getReference();
        if (reference != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context2)) {
                if (!(operator instanceof OCFunctionSymbol)) continue;
                return ((OCFunctionSymbol)operator).getEffectiveType(this);
            }
        }
        OCExpression l = this.getLeft();
        OCExpression r = this.getRight();
        if (l == null) {
            return r != null ? r.getResolvedType(context2) : OCUnknownType.INSTANCE;
        }
        if (r == null) {
            return l.getResolvedType(context2);
        }
        OCElementType sign = this.getOperationSign();
        OCType lt = l.getResolvedType(context2);
        OCType rt = r.getResolvedType(context2);
        return OCBinaryExpressionImpl.getBinaryExprType(sign, lt, rt, OCResolveContext.forPsi(this));
    }

    public static OCType getBinaryExprType(OCElementType sign, OCType lt, OCType rt, @NotNull OCResolveContext ctx) {
        OCType result2;
        if (lt.isUnresolved(ctx) || rt.isUnresolved(ctx)) {
            result2 = OCUnknownType.INSTANCE;
        } else if (OCTokenTypes.LOGIC_OPERATIONS.contains((IElementType)sign) || OCTokenTypes.COMPARISON_OPERATIONS.contains((IElementType)sign)) {
            result2 = OCIntType.getAppropriateBool(ctx.isObjc());
        } else if (lt.isSubclassOfMagic(ctx) || rt.isSubclassOfMagic(ctx)) {
            result2 = new OCMagicType(lt);
        } else if (sign == OCTokenTypes.DOT_MUL || sign == OCTokenTypes.DEREF_MUL) {
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result2 = rt instanceof OCPointerType ? ((OCPointerType)rt).getRefType() : OCBinaryExpressionImpl.unknownOrMagic(lt, rt, ctx);
        } else if (sign == OCTokenTypes.SPACESHIP) {
            result2 = OCIntType.INT;
        } else {
            if (lt instanceof OCCppReferenceType) {
                lt = ((OCCppReferenceType)lt).getRefType();
            }
            if (rt instanceof OCCppReferenceType) {
                rt = ((OCCppReferenceType)rt).getRefType();
            }
            result2 = lt instanceof OCNumericType && rt instanceof OCNumericType && (sign == OCTokenTypes.PLUS || sign == OCTokenTypes.MINUS || sign == OCTokenTypes.DIV || sign == OCTokenTypes.PERC || sign == OCTokenTypes.MUL || sign == OCTokenTypes.AND || sign == OCTokenTypes.OR || sign == OCTokenTypes.XOR) ? lt.getLeastCommonType(rt, ctx) : (lt instanceof OCPointerType && rt instanceof OCPointerType ? OCIntType.ULONG : (lt instanceof OCPointerType && rt.isIntegerCompatible(ctx) ? lt : (rt instanceof OCPointerType && lt.isIntegerCompatible(ctx) ? rt : (!(!lt.isNumberCompatible(ctx) && !lt.isPointerCompatible(ctx) || !rt.isNumberCompatible(ctx) && !rt.isPointerCompatible(ctx)) ? lt : OCBinaryExpressionImpl.unknownOrMagic(lt, rt, ctx)))));
        }
        if (result2 instanceof OCNumericType) {
            result2 = result2.cloneWithoutCVQualifiers(ctx.getProject());
        }
        return result2;
    }

    private static OCType unknownOrMagic(OCType lt, OCType rt, @NotNull OCResolveContext context2) {
        if (lt.isMagicInside(context2) || rt.isMagicInside(context2)) {
            return new OCMagicType(lt);
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Arrays.asList(this.getLeft(), this.getRight());
    }
}

