/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi;

import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSendMessageExpression
extends OCExpression {
    @Nullable
    public OCExpression getReceiverExpression();

    @NotNull
    public List<OCMessageArgument> getArguments();

    @NotNull
    public List<OCArgumentSelector> getArgumentSelectors();

    @NotNull
    public List<OCExpression> getArgumentExpressions();

    @NotNull
    public String getMessageSelector();

    public boolean isVarargCall();

    @Nullable
    public OCObjectTypeContext getReceiverContext();

    @NotNull
    public ProbableResponders getProbableResponders();

    @Nullable
    public String getExpectedMethodSignature(OCResolveContext var1);

    public static class ProbableResponders {
        private final OCObjectTypeContext receiverContext;
        private final List<OCMethodSymbol> allResponders;
        private final List<OCMethodSymbol> filteredByStaticnessResponders;
        private final OCMethodSymbol knownResponder;

        public ProbableResponders(@NotNull List<OCMethodSymbol> allResponders, @NotNull List<OCMethodSymbol> filteredByStaticnessResponders, @Nullable OCMethodSymbol knownResponder, @Nullable OCObjectTypeContext receiverContext) {
            this.allResponders = allResponders;
            this.filteredByStaticnessResponders = filteredByStaticnessResponders;
            this.knownResponder = knownResponder;
            this.receiverContext = receiverContext;
        }

        @NotNull
        public List<OCMethodSymbol> getAllResponders() {
            return this.allResponders;
        }

        @NotNull
        public List<OCMethodSymbol> getFilteredByStaticnessResponders() {
            return this.filteredByStaticnessResponders;
        }

        @Nullable
        public OCMethodSymbol getKnownResponder() {
            return this.knownResponder;
        }

        public boolean isStaticnessMismatch() {
            return this.allResponders.size() > 0 && this.filteredByStaticnessResponders.size() == 0;
        }

        public boolean isStaticContext() {
            return this.receiverContext != null && this.receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC;
        }

        @Nullable
        public OCObjectType getReceiverType() {
            return this.receiverContext != null ? this.receiverContext.getType() : null;
        }

        @Nullable
        public OCType getReceiverOriginalType() {
            return this.receiverContext != null ? this.receiverContext.getOriginalType() : null;
        }
    }
}

