/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.lang.ForeignLeafType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafType;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public class OCMacroForeignLeafElement
extends ForeignLeafPsiElement
implements ExternallyAnnotated {
    private String myMacroName;
    private int myMacroArgumentIndex;
    private TextRange myRangeInMacroArgument;
    private int myOffsetInTopSubstitution;
    private static final Key<Pair<Long, Integer>> START_OFFSET = Key.create((String)"START_OFFSET");

    public OCMacroForeignLeafElement(OCMacroForeignLeafType type, String text, String macroName, int macroArgumentIndex, TextRange rangeInMacroArgument, int inSubstitutionOffset) {
        super((ForeignLeafType)type, (CharSequence)OCNamesInterner.intern(text));
        this.myMacroName = macroName;
        this.myMacroArgumentIndex = macroArgumentIndex;
        this.myRangeInMacroArgument = rangeInMacroArgument;
        this.myOffsetInTopSubstitution = inSubstitutionOffset;
    }

    public int getMacroArgumentIndex() {
        return this.myMacroArgumentIndex;
    }

    public TextRange getRangeInMacroArgument() {
        return this.myRangeInMacroArgument;
    }

    public String getMacroName() {
        return this.myMacroName;
    }

    public int getOffsetInTopSubstitution() {
        return this.myOffsetInTopSubstitution;
    }

    @Nullable
    private Integer getCachedStartOffset(long timeStamp) {
        Pair pair = (Pair)START_OFFSET.get((UserDataHolder)this);
        if (pair != null && (Long)pair.first == timeStamp) {
            return (Integer)pair.second;
        }
        return null;
    }

    public int getStartOffset() {
        PsiFile file2 = this.getContainingFile();
        if (!file2.isValid()) {
            return 0;
        }
        long stamp = file2.getModificationStamp();
        Integer offset = this.getCachedStartOffset(stamp);
        if (offset != null) {
            return offset;
        }
        ArrayList<OCMacroForeignLeafElement> array = new ArrayList<OCMacroForeignLeafElement>();
        array.add(this);
        PsiElement cur = PsiTreeUtil.prevLeaf((PsiElement)this);
        while (offset == null && cur != null && !(cur instanceof PsiFile)) {
            if (cur instanceof ForeignLeafPsiElement) {
                if (cur instanceof OCMacroForeignLeafElement && (offset = ((OCMacroForeignLeafElement)cur).getCachedStartOffset(stamp)) == null) {
                    array.add((OCMacroForeignLeafElement)cur);
                }
            } else if (cur.getTextRange() != null) {
                offset = cur.getTextRange().getEndOffset();
            }
            cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
        }
        if (offset != null) {
            Pair value = Pair.create((Object)stamp, (Object)offset);
            for (OCMacroForeignLeafElement macroForeignLeafElement : array) {
                START_OFFSET.set((UserDataHolder)macroForeignLeafElement, (Object)value);
            }
            return offset;
        }
        return 0;
    }

    public TextRange getTextRange() {
        int start = this.getStartOffset();
        return new TextRange(start, start);
    }

    public void copyFromElement(OCMacroForeignLeafElement element) {
        this.myMacroName = element.myMacroName;
        this.myMacroArgumentIndex = element.myMacroArgumentIndex;
        this.myRangeInMacroArgument = element.myRangeInMacroArgument;
        this.myOffsetInTopSubstitution = element.myOffsetInTopSubstitution;
    }

    @Nullable
    public TextRange getAnnotationRegion() {
        OCMacroRange call = OCElementUtil.getRangeInMacroCall((PsiElement)this);
        if (call != null && call.mapsToArguments()) {
            return call.getTextRange();
        }
        return null;
    }
}

