/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.navigation;

import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.UIBundle;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.navigation.OCGotoAction;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class OCGotoActionAsync<Psi extends PsiElement>
extends OCGotoAction<Psi> {
    @NotNull
    private final Function<Psi, Query<? extends OCSymbol>> myQueryProvider;
    private BackgroundUpdaterTask updater = null;

    public OCGotoActionAsync(@NotNull Psi source, @NotNull String name, @NotNull Icon icon, @NotNull Function<Psi, Query<? extends OCSymbol>> queryProvider) {
        super(source, name, icon);
        this.myQueryProvider = queryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void navigate(@Nullable MouseEvent mouseEvent, Editor editor) {
        Object source;
        if (this.updater != null) {
            this.updater.cancelTask();
        }
        if ((source = this.getSource()) == null) {
            return;
        }
        ProgressIndicatorBase queryIndicator = new ProgressIndicatorBase();
        Promise queryPromise = Promises.runAsync(() -> this.lambda$navigate$3(source, (ProgressIndicator)queryIndicator));
        boolean success = false;
        try {
            success = this.doNavigate((Promise<Query<OCSymbol>>)queryPromise, (ProgressIndicator)queryIndicator, mouseEvent, editor, source);
        }
        finally {
            if (!success) {
                queryIndicator.cancel();
            }
        }
    }

    private boolean doNavigate(@NotNull Promise<Query<? extends OCSymbol>> queryPromise, @NotNull ProgressIndicator queryIndicator, @Nullable MouseEvent mouseEvent, Editor editor, @NotNull Psi source) {
        Project project2 = source.getProject();
        AtomicReference firstTargetRef = new AtomicReference();
        if (OCGotoActionAsync.runAndWait(this.getName(), 100, firstTargetRef, () -> {
            OCSymbol firstTarget;
            Query query = (Query)OCGotoActionAsync.waitForPromise(queryPromise);
            if (query == null) {
                return null;
            }
            Query query2 = query;
            synchronized (query2) {
                firstTarget = (OCSymbol)query.findFirst();
            }
            if (firstTarget == null) {
                return null;
            }
            PsiElement firstPsiTarget = firstTarget.locateDefinition(project2);
            if (!(firstPsiTarget instanceof NavigatablePsiElement)) {
                return null;
            }
            return (NavigatablePsiElement)firstPsiTarget;
        }) && firstTargetRef.get() == null) {
            return false;
        }
        NavigatablePsiElement[] firstTargets = firstTargetRef.get() != null ? new NavigatablePsiElement[]{(NavigatablePsiElement)firstTargetRef.get()} : NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY;
        PsiElementListCellRenderer<PsiElement> renderer = this.createRenderer(source, (PsiElement[])firstTargets);
        String name = this.getName();
        this.updater = this.createGotoAsyncUpdater(project2, name, queryPromise, queryIndicator, renderer.getComparator());
        if (OCGotoActionAsync.createAndShowPopup(firstTargets, project2, name, renderer, this.updater, mouseEvent, editor)) {
            assert (this.updater != null) : "How is this possible?";
            ProgressManager.getInstance().run((Task)this.updater);
            return true;
        }
        return false;
    }

    private static boolean createAndShowPopup(NavigatablePsiElement @NotNull [] firstTargets, @NotNull Project project2, @NotNull String name, @NotNull PsiElementListCellRenderer<PsiElement> renderer, @Nullable BackgroundUpdaterTask updater, @Nullable MouseEvent mouseEvent, Editor editor) {
        CustomNavigateOrPopupHelper helper = new CustomNavigateOrPopupHelper(firstTargets, name);
        JBPopup popup = helper.setFindUsagesTitle(name).setListRenderer(renderer).setListUpdaterTask(updater).setProject(project2).navigateOrCreatePopup();
        if (popup == null) {
            return false;
        }
        if (helper.getContentsList() != null) {
            helper.getContentsList().setEmptyText(OCBundle.message("navigation.goto.please.wait", new Object[0]));
            if (updater instanceof GotoAsyncUpdater) {
                ((GotoAsyncUpdater)updater).setPopupContentsList(helper.getContentsList());
            }
        }
        if (mouseEvent != null) {
            RelativePoint point = new RelativePoint(mouseEvent);
            popup.show(point);
            return true;
        }
        popup.showInBestPositionFor(editor);
        return true;
    }

    @NotNull
    public Function<Psi, Query<? extends OCSymbol>> getQueryProvider() {
        return this.myQueryProvider;
    }

    @NotNull
    protected BackgroundUpdaterTask createGotoAsyncUpdater(@Nullable Project project2, @NotNull String title, @NotNull Promise<Query<? extends OCSymbol>> targetQueryPromise, @NotNull ProgressIndicator queryIndicator, @Nullable Comparator<PsiElement> comparator) {
        return new GotoAsyncUpdater(project2, title, targetQueryPromise, queryIndicator, comparator);
    }

    @Override
    @Nullable
    public Collection<? extends OCSymbol> getTargets() {
        Object source = this.getSource();
        if (source == null) {
            return null;
        }
        return ((Query)this.myQueryProvider.fun(source)).findAll();
    }

    @Nullable
    private static <T> T waitForPromise(@NotNull Promise<T> promise) {
        while (promise.getState() == Promise.State.PENDING) {
            ProgressManager.checkCanceled();
            try {
                return (T)promise.blockingGet(50, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException ex) {
                return null;
            }
        }
        if (promise.getState() == Promise.State.SUCCEEDED) {
            try {
                return (T)promise.blockingGet(Integer.MAX_VALUE);
            }
            catch (ExecutionException | TimeoutException ex) {
                LOG.error((Throwable)ex);
            }
        }
        return null;
    }

    private /* synthetic */ Query lambda$navigate$3(PsiElement source, ProgressIndicator queryIndicator) {
        Ref result2 = Ref.create();
        ConcurrencyUtil.runUnderThreadName((String)"Creating goto query...", () -> ReadAction.run(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> result2.set(this.myQueryProvider.fun((Object)source)), queryIndicator)));
        return (Query)result2.get();
    }

    protected static class GotoAsyncUpdater
    extends BackgroundUpdaterTask {
        @NotNull
        private final Promise<Query<? extends OCSymbol>> myTargetQueryPromise;
        @NotNull
        private final ProgressIndicator myQueryIndicator;
        @Nullable
        private JBList myPopupContentsList;

        public GotoAsyncUpdater(@Nullable Project project2, @NotNull String title, @NotNull Promise<Query<? extends OCSymbol>> targetQueryPromise, @NotNull ProgressIndicator queryIndicator, @Nullable Comparator<PsiElement> comparator) {
            super(project2, title, comparator);
            this.myTargetQueryPromise = targetQueryPromise;
            this.myQueryIndicator = queryIndicator;
        }

        public String getCaption(int size) {
            return this.getTitle() + " (" + size + " " + StringUtil.pluralize((String)"element", (int)size) + " found)";
        }

        public void run(@NotNull ProgressIndicator indicator) {
            super.run(indicator);
            Runnable action = () -> {
                Query targetQuery = (Query)OCGotoActionAsync.waitForPromise(this.myTargetQueryPromise);
                if (targetQuery == null) {
                    indicator.cancel();
                    return;
                }
                Query query = targetQuery;
                synchronized (query) {
                    targetQuery.forEachAsync(symbol -> {
                        PsiElement element = symbol.locateDefinition(this.myProject);
                        if (element != null) {
                            if (!this.updateComponent(element)) {
                                indicator.cancel();
                            }
                            return !indicator.isCanceled();
                        }
                        return true;
                    });
                }
            };
            Ref result2 = new Ref((Object)Boolean.FALSE);
            boolean success = ProgressIndicatorUtils.runWithWriteActionPriority(() -> result2.set((Object)ApplicationManagerEx.getApplicationEx().tryRunReadAction(action)), (ProgressIndicator)indicator);
            if (!success || !((Boolean)result2.get()).booleanValue()) {
                UIUtil.invokeAndWaitIfNeeded(() -> this.myPopup.cancel());
            }
        }

        public void onSuccess() {
            super.onSuccess();
            PsiElement oneElement = this.getTheOnlyOneElement();
            if (oneElement instanceof NavigatablePsiElement) {
                ((NavigatablePsiElement)oneElement).navigate(true);
                this.myPopup.cancel();
            }
        }

        public void onFinished() {
            super.onFinished();
            this.myQueryIndicator.cancel();
            if (this.getCurrentSize() == 0) {
                if (this.myPopupContentsList != null) {
                    this.myPopupContentsList.setEmptyText(UIBundle.message((String)"message.noMatchesFound", (Object[])new Object[0]));
                } else {
                    this.myPopup.cancel();
                }
            }
        }

        public void setPopupContentsList(@Nullable JBList popupContentsList) {
            this.myPopupContentsList = popupContentsList;
        }
    }

    private static class CustomNavigateOrPopupHelper
    extends PsiElementListNavigator.NavigateOrPopupHelper<NavigatablePsiElement> {
        @Nullable
        private JBList<NavigatablePsiElement> myContentsList;

        private CustomNavigateOrPopupHelper(NavigatablePsiElement @NotNull [] targets, @NotNull String title) {
            super(targets, title);
        }

        protected boolean allowEmptyTargets() {
            return true;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<NavigatablePsiElement> builder2) {
            JComponent chooser;
            super.afterPopupBuilderCreated(builder2);
            if (builder2 instanceof PopupChooserBuilder && (chooser = ((PopupChooserBuilder)builder2).getChooserComponent()) instanceof JBList) {
                this.myContentsList = (JBList)chooser;
            }
        }

        @Nullable
        private JBList<NavigatablePsiElement> getContentsList() {
            return this.myContentsList;
        }
    }
}

