/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class OCEndlessLoopFinder
extends OCDataFlowAlgorithm {
    private final Stack<OCNode> myTopologicalOrder = new Stack();
    private final List<OCNode> myComponent = new ArrayList<OCNode>();
    private final List<OCNode> myEndlessLoops = new ArrayList<OCNode>();
    private final List<OCNode> myUnreachedNodes = new ArrayList<OCNode>();
    private boolean myForwardMode;

    OCEndlessLoopFinder(@NotNull OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myEndlessLoops.clear();
        this.myTopologicalOrder.clear();
        this.myUnreachedNodes.clear();
        this.clearProcessedNodes();
        this.myForwardMode = true;
        this.traverse(this.myCfg.getStartNode(), null, null, true);
        for (OCNode node2 : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node2, null)) continue;
            this.myUnreachedNodes.add(node2);
        }
        this.myForwardMode = false;
        this.clearProcessedNodes();
        while (!this.myTopologicalOrder.isEmpty()) {
            OCNode node3 = (OCNode)this.myTopologicalOrder.pop();
            if (this.isNodeProcessed(node3, null)) continue;
            this.myComponent.clear();
            this.traverse(node3, null, null, false);
            if (!this.isEndlessLoop(this.myComponent)) continue;
            this.myEndlessLoops.addAll(this.myComponent);
        }
    }

    private boolean isEndlessLoop(@NotNull List<OCNode> component) {
        boolean wasJump = false;
        for (OCNode node2 : component) {
            if (this.myUnreachedNodes.contains(node2) || node2.getJumpTargets() == null) continue;
            wasJump = true;
            for (OCNode target : node2.getJumpTargets()) {
                if (this.myUnreachedNodes.contains(target) || this.isNodeProcessed(target, null)) continue;
                return false;
            }
        }
        return wasJump;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node2) {
        if (this.myForwardMode) {
            this.myTopologicalOrder.push((Object)node2);
        } else {
            this.myComponent.add(node2);
        }
    }

    @NotNull
    public List<OCElementsRange> getEndlessLoops() {
        return OCEndlessLoopFinder.getRanges(this.myEndlessLoops, true);
    }
}

