/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSplitFunctionIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        return OCBundle.message("intentions.split.function", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (!OCCodeInsightUtil.isValid((PsiElement)file2)) {
            return false;
        }
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        return function != null && function.getNamespaceQualifier() == null;
    }

    public void invoke(final @NotNull Project project2, final Editor editor, final PsiFile file2) throws IncorrectOperationException {
        if (file2 == null || editor == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final Ref result2 = Ref.create();
        new Task.Modal(project2, OCBundle.message("intentions.split.function.progress.text", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> result2.set((Object)OCSplitFunctionIntentionAction.prepareData(project2, editor, file2)), (ProgressIndicator)indicator);
            }
        }.queue();
        if (result2.isNull()) {
            throw new ProcessCanceledException();
        }
        Set files = ContainerUtil.set((Object[])new PsiFile[]{file2, ((SplitFunctionData)result2.get()).pos.file});
        WriteCommandAction.runWriteCommandAction((Project)project2, (String)this.getText(), null, () -> OCSplitFunctionIntentionAction.doSplit(project2, (SplitFunctionData)result2.get()), (PsiFile[])files.toArray(PsiFile.EMPTY_ARRAY));
    }

    @Nullable
    private static SplitFunctionData prepareData(@NotNull Project project2, Editor editor, PsiFile file2) {
        OCFunctionSymbol symbol;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        OCFunctionDefinition function = OCSplitFunctionIntentionAction.getFunction(editor, file2);
        OCFunctionSymbol oCFunctionSymbol = symbol = function != null ? function.getSymbol() : null;
        if (symbol == null) {
            return null;
        }
        Document declarationDocument = psiDocumentManager.getDocument(function.getContainingFile());
        if (declarationDocument == null) {
            return null;
        }
        TextRange oldBodyRange = OCSplitFunctionIntentionAction.getBodyRange(function);
        if (oldBodyRange == null) {
            return null;
        }
        OCGenerateUtil.ReplacePosition pos = OCCppDefinitionsUtil.getOutsidePreferredPosition(file2, OCCppDefinitionsUtil.getFunctionParent(symbol, project2), Collections.singletonList(symbol));
        if (pos == null) {
            return null;
        }
        Document definitionDocument = psiDocumentManager.getDocument(pos.file);
        if (definitionDocument == null) {
            return null;
        }
        String definitionSignature = (OCGenerateUtil.shouldInsertNewLineBefore(definitionDocument.getCharsSequence(), pos.range.getStartOffset()) ? "\n" : "") + OCCppDefinitionsUtil.functionSignature(symbol, true, pos.context);
        String bodyText = declarationDocument.getText(oldBodyRange) + (OCGenerateUtil.shouldInsertNewLineAfter(definitionDocument.getCharsSequence(), pos.range.getEndOffset()) ? "\n" : "");
        return new SplitFunctionData(declarationDocument, oldBodyRange, pos, definitionDocument, definitionSignature, bodyText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSplit(@NotNull Project project2, @NotNull SplitFunctionData d) {
        RangeMarker newLocation = null;
        RangeMarker signature = null;
        RangeMarker body = null;
        try {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(d.declarationDocument);
            if (d.declarationDocument != d.definitionDocument) {
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(d.definitionDocument);
            }
            newLocation = d.definitionDocument.createRangeMarker(d.pos.range);
            d.declarationDocument.replaceString(d.oldBodyRange.getStartOffset(), d.oldBodyRange.getEndOffset(), (CharSequence)";");
            int definitionOffset = newLocation.getStartOffset();
            d.definitionDocument.deleteString(newLocation.getStartOffset(), newLocation.getEndOffset());
            signature = d.definitionDocument.createRangeMarker(definitionOffset, definitionOffset);
            signature.setGreedyToRight(true);
            d.definitionDocument.insertString(definitionOffset, (CharSequence)d.definitionSignature);
            signature.setGreedyToRight(false);
            body = d.definitionDocument.createRangeMarker(signature.getEndOffset(), signature.getEndOffset());
            body.setGreedyToRight(true);
            d.definitionDocument.insertString(body.getStartOffset(), (CharSequence)d.bodyText);
            body.setGreedyToRight(false);
            psiDocumentManager.commitDocument(d.definitionDocument);
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, signature.getStartOffset(), signature.getEndOffset());
            psiDocumentManager.commitDocument(d.definitionDocument);
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, body.getStartOffset(), body.getStartOffset() + 1);
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(d.pos.file, TextRange.create((int)body.getStartOffset(), (int)body.getEndOffset()));
            OCChangeUtil.reformatTextIfNotInjected(d.pos.file, body.getEndOffset(), CharArrayUtil.shiftForward((CharSequence)d.definitionDocument.getCharsSequence(), (int)body.getEndOffset(), (String)" \t\n"));
            psiDocumentManager.commitDocument(d.declarationDocument);
            OCFunctionDeclaration func = (OCFunctionDeclaration)PsiTreeUtil.getParentOfType((PsiElement)d.pos.file.findElementAt(signature.getEndOffset()), OCFunctionDeclaration.class);
            PsiElement identifier = func != null ? func.getNameIdentifier() : null;
            OCCodeInsightUtil.openInEditor((PsiElement)ObjectUtils.notNull((Object)identifier, (Object)d.pos.file));
        }
        finally {
            if (body != null) {
                body.dispose();
            }
            if (signature != null) {
                signature.dispose();
            }
            if (newLocation != null) {
                newLocation.dispose();
            }
        }
    }

    @Nullable
    private static TextRange getBodyRange(@NotNull OCFunctionDefinition function) {
        OCDeclarator lastElementToKeep;
        OCConstructorInitializationList initializationList = function.getConstructorInitializationList();
        if (initializationList != null) {
            PsiElement cur;
            for (cur = initializationList.getPrevSibling(); !(cur == null || OCElementUtil.isElementSignificant(cur) && OCElementUtil.getElementType(cur) != OCTokenTypes.COLON); cur = cur.getPrevSibling()) {
            }
            lastElementToKeep = cur;
        } else {
            lastElementToKeep = function.getDeclarator();
        }
        if (lastElementToKeep == null) {
            return null;
        }
        return TextRange.create((int)OCElementUtil.getRangeWithMacros(lastElementToKeep).getEndOffset(), (int)function.getTextRange().getEndOffset());
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    protected static OCFunctionDefinition getFunction(Editor editor, PsiFile file2) {
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset());
        return (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)element, OCFunctionDefinition.class, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
    }

    private static class SplitFunctionData {
        public final Document declarationDocument;
        public final TextRange oldBodyRange;
        public final OCGenerateUtil.ReplacePosition pos;
        public final Document definitionDocument;
        public final String definitionSignature;
        public final String bodyText;

        private SplitFunctionData(Document declarationDocument, TextRange oldBodyRange, OCGenerateUtil.ReplacePosition pos, Document definitionDocument, String definitionSignature, String bodyText) {
            this.declarationDocument = declarationDocument;
            this.oldBodyRange = oldBodyRange;
            this.pos = pos;
            this.definitionDocument = definitionDocument;
            this.definitionSignature = definitionSignature;
            this.bodyText = bodyText;
        }
    }
}

