/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OurClangTidyInspection
extends ClangTidyInspectionBase {
    private final Logger LOG = Logger.getInstance(((Object)((Object)this)).getClass());

    protected OurClangTidyInspection() {
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    public abstract String getCheckName();

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return clangTidyMessage;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file2, @NotNull Project project2) {
        return false;
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return this.getShortName();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, final boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file2) {
                if (isOnTheFly) {
                    return;
                }
                if (!OCLanguageUtils.isSupported(file2)) {
                    return;
                }
                ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(file2.getProject());
                VirtualFile virtualFile = file2.getViewProvider().getVirtualFile();
                try {
                    List allDiagnostics = service.computeWithOpenedAndParsed(virtualFile, response -> ClangUtils.waitForClangFuture(response.getOurTidyDiagnostics()));
                    if (allDiagnostics != null) {
                        List diagnostics2 = ContainerUtil.filter((Collection)allDiagnostics, diagnostic -> diagnostic.getDiagnosticName().equals(OurClangTidyInspection.this.getCheckName()));
                        ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
                        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
                        if (document2 != null) {
                            applier.applySuccess(file2, diagnostics2, problemsHolder);
                        }
                    }
                }
                catch (Exception e) {
                    OurClangTidyInspection.this.LOG.warn(((Object)((Object)this)).getClass().getName() + " in batch mode failed.", (Throwable)e);
                }
            }
        };
    }
}

