/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCConvertObjCLiteralIntentionAction;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCLegacyObjCLiteralInspection
extends OCInspections.GeneralObjC {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return OCInspectionsBundle.message("inspection.modern.syntax", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        return new OCVisitor(){

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expr) {
                OCConvertObjCLiteralIntentionAction action;
                OCConvertObjCLiteralIntentionAction.Converter converter = OCConvertObjCLiteralIntentionAction.findConverter(expr);
                if (converter != null && (action = new OCConvertObjCLiteralIntentionAction(expr, converter)).isAvailable(expr)) {
                    OCLegacyObjCLiteralInspection.this.registerProblem(holder, null, null, isOnTheFly, expr, "Modern syntax can be used", "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, action);
                }
            }
        };
    }
}

