/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection {
    public static final String DISPLAY_NAME = "Clang-Tidy";
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    private boolean myPreferClangTidyFilesOverIDESettings = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    @Override
    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @NotNull
    public static String getInspectionShortName() {
        return new ClangTidyInspection().getShortName();
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClangTidyInspection.addComponent((Component)this.createClangTidyFilesCheckbox(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsBottom((int)10));
        ClangTidyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 1, 1, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent((Component)new JBLabel(OCInspectionsBundle.message("configurable.clangTidy.checks.hint", new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), childPanel, 0, 1, 2, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 1, 2, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent(this.createOptionsButton(childPanel), childPanel, 0, 2, 3, 1, 1, (Insets)JBUI.emptyInsets());
        builder2.addComponent((JComponent)childPanel);
        builder2.addComponent((JComponent)OCInspectionUtil.createLinkToConfigurable(OCInspectionsBundle.message("configurable.clangTidy.executable", new Object[0]), ClangTidyConfigurable.class, null, null), 10);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)builder2.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    @NotNull
    private JBCheckBox createClangTidyFilesCheckbox() {
        final JBCheckBox checkBox = new JBCheckBox(OCInspectionsBundle.message("configurable.clangTidy.prefer.files.over.ide.settings", new Object[0]), this.myPreferClangTidyFilesOverIDESettings);
        checkBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myPreferClangTidyFilesOverIDESettings = checkBox.isSelected();
            }
        });
        return checkBox;
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return isBatchMode ? clangTidyMessage : "Clang-Tidy: " + clangTidyMessage;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file2, @NotNull Project project2) {
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)project2.getService(ClangTidyFilesState.class);
        return !this.myPreferClangTidyFilesOverIDESettings || !clangTidyFilesState.hasClangTidyFilesInPath(new File(file2.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return clangTidyCheckName;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel2, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        panel2.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton(OCInspectionsBundle.message("configurable.clangTidy.checks.options.button", new Object[0]));
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List checkOptions = ClangTidyInspection.this.myClangTidyCheckOptions;
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, checkOptions);
                optionsDialog.showAndGet();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(checkOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = checkOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel2;
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClangTidyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ClangTidyInspection.this.myClangTidyChecks = checksEditor.getText();
            }
        });
        return checksEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel(OCInspectionsBundle.message("configurable.clangTidy.example.link", new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return hint;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager2, boolean isOnTheFly) {
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file2, @NotNull GlobalInspectionContext context2, @NotNull InspectionManager manager2) {
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(this);
        return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file2, (InspectionManager)manager2, (boolean)false, (ExternalAnnotator)annotator);
    }

    public boolean isPreferClangTidyFilesOverIDESettings() {
        return this.myPreferClangTidyFilesOverIDESettings;
    }

    public void setPreferClangTidyFilesOverIDESettings(boolean preferClangTidyFilesOverIDESettings) {
        this.myPreferClangTidyFilesOverIDESettings = preferClangTidyFilesOverIDESettings;
    }

    @NotNull
    public String getClangTidyChecks() {
        return !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        return StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
    }

    @NotNull
    public static String getAllEnabledChecks() {
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        return "-*";
    }

    private static List<String> getDefaultChecksConfiguration() {
        List<String> checksToDisable = Arrays.asList("-android-*", "-bugprone-bool-pointer-implicit-conversion", "-bugprone-exception-escape", "-bugprone-signed-char-misuse", "-bugprone-infinite-loop", "-cert-env33-c", "-cert-dcl50-cpp", "-cert-mem57-cpp", "-cert-oop57-cpp", "-cert-oop58-cpp", "-cppcoreguidelines-avoid-goto", "-cppcoreguidelines-macro-usage", "-cppcoreguidelines-no-malloc", "-cppcoreguidelines-owning-memory", "-cppcoreguidelines-pro-bounds-array-to-pointer-decay", "-cppcoreguidelines-pro-bounds-constant-array-index", "-cppcoreguidelines-pro-bounds-pointer-arithmetic", "-cppcoreguidelines-pro-type-const-cast", "-cppcoreguidelines-pro-type-cstyle-cast", "-cppcoreguidelines-pro-type-reinterpret-cast", "-cppcoreguidelines-pro-type-union-access", "-cppcoreguidelines-pro-type-vararg", "-cppcoreguidelines-special-member-functions", "-cppcoreguidelines-init-variables", "-cppcoreguidelines-avoid-non-const-global-variables", "-darwin-*", "-fuchsia-*", "-google-*", "-hicpp-avoid-goto", "-hicpp-no-assembler", "-llvm-*", "-llvmlibc-*", "-linuxkernel-*", "-objc-*", "-readability-else-after-return", "-readability-implicit-bool-conversion", "-readability-magic-numbers", "-readability-named-parameter", "-readability-simplify-boolean-expr", "-readability-braces-around-statements", "-readability-identifier-naming", "-readability-isolate-declaration", "-readability-function-size", "-readability-redundant-member-init", "-readability-redundant-preprocessor", "-readability-uppercase-literal-suffix", "-readability-qualified-auto", "-readability-redundant-access-specifiers", "-portability-restrict-system-includes", "-misc-bool-pointer-implicit-conversion", "-misc-definitions-in-headers", "-misc-non-private-member-variables-in-classes", "-misc-redundant-expression", "-misc-static-assert", "-misc-unused-alias-decls", "-misc-unused-parameters", "-misc-unused-using-decls", "-modernize-avoid-c-arrays", "-modernize-use-using", "-modernize-use-default-member-init", "-modernize-use-trailing-return-type", "-openmp-exception-escape", "-clang-diagnostic-*", "-clang-analyzer-*", "-zircon-*");
        List<String> aliasChecksToDisable = Arrays.asList("-bugprone-narrowing-conversions", "-hicpp-vararg", "-hicpp-use-override", "-hicpp-use-nullptr", "-hicpp-use-noexcept", "-hicpp-use-equals-delete", "-hicpp-use-equals-default", "-hicpp-use-emplace", "-hicpp-use-auto", "-hicpp-uppercase-literal-suffix", "-hicpp-undelegated-constructor", "-hicpp-static-assert", "-hicpp-special-member-functions", "-hicpp-noexcept-move", "-hicpp-no-malloc", "-hicpp-no-array-decay", "-hicpp-new-delete-operators", "-hicpp-named-parameter", "-hicpp-move-const-arg", "-hicpp-member-init", "-hicpp-invalid-access-moved", "-hicpp-function-size", "-hicpp-explicit-conversions", "-hicpp-deprecated-headers", "-hicpp-braces-around-statements", "-hicpp-avoid-c-arrays", "-google-readability-namespace-comments", "-google-readability-function-size", "-google-readability-braces-around-statements", "-fuchsia-header-anon-namespaces", "-cppcoreguidelines-non-private-member-variables-in-classes", "-cppcoreguidelines-explicit-virtual-functions", "-cppcoreguidelines-c-copy-assignment-signature", "-cppcoreguidelines-avoid-magic-numbers", "-cppcoreguidelines-avoid-c-arrays", "-cert-pos44-c", "-cert-oop54-cpp", "-cert-oop11-cpp", "-cert-msc32-c", "-cert-msc30-c", "-cert-fio38-c", "-cert-err61-cpp", "-cert-err09-cpp", "-cert-dcl59-cpp", "-cert-dcl54-cpp", "-cert-dcl51-cpp", "-cert-dcl37-c", "-cert-dcl16-c", "-cert-dcl03-c", "-cert-con36-c", "-cert-con54-cpp");
        List<String> checksToEnable = Arrays.asList("google-default-arguments", "google-explicit-constructor", "google-runtime-operator");
        checksToDisable.sort(String::compareTo);
        aliasChecksToDisable.sort(String::compareTo);
        checksToEnable.sort(String::compareTo);
        ArrayList<String> configuration = new ArrayList<String>();
        configuration.add("*");
        configuration.addAll(checksToDisable);
        configuration.addAll(aliasChecksToDisable);
        configuration.addAll(checksToEnable);
        return ContainerUtil.newUnmodifiableList(configuration);
    }
}

