/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.ide.hierarchy.CallHierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.PopupHandler;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.call.OCCalleeMethodsTreeStructure;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallerMethodsTreeStructure;
import com.jetbrains.cidr.lang.psi.OCCallable;
import java.util.Comparator;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public final class OCCallHierarchyBrowser
extends CallHierarchyBrowserBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.hierarchy.call.CallHierarchyBrowser");

    public OCCallHierarchyBrowser(Project project2, OCCallable method) {
        super(project2, (PsiElement)method);
    }

    protected void createTrees(@NotNull Map<String, JTree> type2TreeMap) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction("CallHierarchyPopupMenu");
        JTree tree1 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree1, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        type2TreeMap.put(OCCallHierarchyBrowser.getCalleeType(), tree1);
        JTree tree2 = this.createTree(false);
        PopupHandler.installPopupHandler((JComponent)tree2, (ActionGroup)group, (String)"TypeHierarchyViewPopup", (ActionManager)actionManager);
        type2TreeMap.put(OCCallHierarchyBrowser.getCallerType(), tree2);
    }

    protected PsiElement getElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof OCCallHierarchyNodeDescriptor) {
            OCCallHierarchyNodeDescriptor nodeDescriptor = (OCCallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getEnclosingElement();
        }
        return null;
    }

    protected PsiElement getOpenFileElementFromDescriptor(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor instanceof OCCallHierarchyNodeDescriptor) {
            OCCallHierarchyNodeDescriptor nodeDescriptor = (OCCallHierarchyNodeDescriptor)descriptor;
            return nodeDescriptor.getTargetElement();
        }
        return null;
    }

    protected boolean isApplicableElement(@NotNull PsiElement element) {
        return element instanceof OCCallable && element instanceof NavigatablePsiElement;
    }

    protected HierarchyTreeStructure createHierarchyTreeStructure(@NotNull String typeName, @NotNull PsiElement psiElement) {
        if (OCCallHierarchyBrowser.getCallerType().equals(typeName)) {
            return new OCCallerMethodsTreeStructure(this.myProject, (OCCallable)psiElement, this.getCurrentScopeType());
        }
        if (OCCallHierarchyBrowser.getCalleeType().equals(typeName)) {
            return new OCCalleeMethodsTreeStructure(this.myProject, (OCCallable)psiElement, this.getCurrentScopeType());
        }
        LOG.error("unexpected type: " + typeName);
        return null;
    }

    protected Comparator<NodeDescriptor<?>> getComparator() {
        return AlphaComparator.INSTANCE;
    }
}

