/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.application.options.CodeStyle;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIvarsHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCPropertySymbol, OCGenerateIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption("Show synthesized properties");

    @Override
    protected String getMembersChooserTitle() {
        return "Select Properties to make Instance Variables";
    }

    @Override
    @NotNull
    protected String getActionTitle() {
        return "Generate Instance Variables from Properties";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateIvarsActionContext context2) {
        return context2.getParentNameUppercase() + " has no properties to generate instance variables from";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file2, Editor editor, @NotNull OCGenerateIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options2) {
        options2.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        super.loadOptions(file2, editor, actionContext, settings, options2);
    }

    @Override
    @NotNull
    protected OCGenerateIvarsActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        return new OCGenerateIvarsActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
    }

    public static boolean isPropertyDefective(OCPropertySymbol property, @NotNull Project project2) {
        OCClassSymbol parent = property.getParent();
        if (parent instanceof OCProtocolSymbol) {
            return false;
        }
        OCType type = parent.getType().resolve(OCResolveContext.forSymbol(parent, project2), true);
        if (type instanceof OCObjectType) {
            OCGenerateIvarsActionContext context2 = new OCGenerateIvarsActionContext(parent, (OCObjectType)type, parent.getContainingOCFile(project2));
            return OCGenerateIvarsHandler.getDefectiveCondition(context2).value((Object)property);
        }
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file2, @NotNull OCGenerateIvarsActionContext context2, @NotNull List<OCPropertySymbol> properties) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file2, OCCodeStyleSettings.class);
        boolean declareInImpl = OCCompilerFeaturesHelper.supportsIvarsInImplementation() && settings.PUT_IVARS_TO_IMPLEMENTATION;
        this.performAction(file2, context2, properties, null, declareInImpl);
    }

    public void performAction(PsiFile file2, OCGenerateIvarsActionContext context2, List<OCPropertySymbol> properties, String customName, boolean declareInImplementation) {
        OCClassSymbol parent;
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context2.getInterfaceSymbol();
        OCImplementationSymbol implementationSymbol = context2.getImplementationSymbol();
        HashMap ivarNames = new HashMap();
        ArrayList<String> nonReleasedIvarNames = new ArrayList<String>();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllProps = this.replaceAllProperties();
        Condition<OCPropertySymbol> defectiveCondition = OCGenerateIvarsHandler.getDefectiveCondition(context2);
        PsiFile psiContext = context2.getContext().isValid() ? context2.getContext() : file2;
        ArrayList<OCPropertySymbol> nonReleasedProperties = new ArrayList<OCPropertySymbol>();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file2);
        ApplicationManager.getApplication().runWriteAction(() -> this.lambda$performAction$0(properties, replaceAllProps, defectiveCondition, context2, customName, ivarNames, interfaceSymbol, implementationSymbol, (PsiElement)psiContext, file2, newDeclarations, existingDeclarations, synthesizes, ivarsInfo, nonReleasedProperties, nonReleasedIvarNames));
        if (!newDeclarations.isEmpty()) {
            Boolean generateIvars = this.generateIvars(file2.getProject());
            if (generateIvars == null) {
                return;
            }
            if (!generateIvars.booleanValue()) {
                newDeclarations.clear();
            }
        }
        OCReleaseVariablesIntentionAction releaseAction = null;
        if (OCCompilerFeaturesHelper.isArcDisabled(file2) && !nonReleasedProperties.isEmpty()) {
            parent = properties.get(0).getParent();
            releaseAction = new OCReleaseVariablesIntentionAction(OCSymbolKind.INSTANCE_VARIABLE, parent, nonReleasedProperties, nonReleasedIvarNames, file2.getProject());
        }
        parent = declareInImplementation ? context2.getImplementationSymbol() : context2.getInterfaceSymbol();
        OCConvertMemberRefactoringProcessor<OCPropertySymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCPropertySymbol>(parent, properties, ivarNames, newDeclarations, existingDeclarations, replaceAllProps ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DEREF, this.getActionTitle(), replaceAllProps, context2.getProject()){

            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGenerateIvarsHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllProperties() {
        return false;
    }

    @Nullable
    protected static Boolean askGenerateIvars(Project project2) {
        Ref result2 = Ref.create();
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        OCCodeStyleSettings.RememberedOption option = OCCodeStyleSettings.askAndSave(settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES, "Do you want to generate instance variables for chosen properties?", "Generate instance variables", (Ref<Boolean>)result2);
        if (option == null) {
            return null;
        }
        settings.GENERATE_INSTANCE_VARIABLES_FOR_PROPERTIES = option;
        return (Boolean)result2.get();
    }

    @Nullable
    protected Boolean generateIvars(Project project2) {
        if (this.replaceAllProperties()) {
            return true;
        }
        return OCGenerateIvarsHandler.askGenerateIvars(project2);
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCGenerateIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGenerateIvarsHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        Condition<OCPropertySymbol> condition = OCGenerateIvarsHandler.getDefectiveCondition(actionContext);
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, condition), actionContext, moreNodesLevel);
    }

    private static Condition<OCPropertySymbol> getDefectiveCondition(OCGenerateIvarsActionContext actionContext) {
        HashMap implementedProperties = new HashMap();
        actionContext.getType().processMembers(OCMemberSymbol.class, member -> {
            if (member instanceof OCSynthesizeSymbol) {
                implementedProperties.put(member.getName(), 10);
            } else if (member instanceof OCMethodSymbol && member.isDefinition()) {
                OCPropertySymbol property;
                OCMethodSymbol intfMethod = (OCMethodSymbol)member.getAssociatedSymbol(actionContext.getProject());
                OCPropertySymbol oCPropertySymbol = property = intfMethod != null ? intfMethod.getGeneratedFromProperty() : null;
                if (property != null) {
                    Integer curValue = (Integer)implementedProperties.get(property.getName());
                    implementedProperties.put(property.getName(), curValue != null ? curValue + 1 : 1);
                }
            }
            return true;
        });
        return property -> {
            String categoryName = property.getParent().getCategoryName();
            if (categoryName != null && !categoryName.isEmpty()) {
                return false;
            }
            if (property.getParent().equals(actionContext.getInterfaceSymbol())) {
                Integer value = (Integer)implementedProperties.get(property.getName());
                return (property.isReadonly() ? 1 : 2) > (value != null ? value : 0);
            }
            return property.getAssociatedSymbol(actionContext.getProject()) == null;
        };
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCPropertySymbol> candidates, OCOption option, OCGenerateIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private /* synthetic */ void lambda$performAction$0(List properties, boolean replaceAllProps, Condition defectiveCondition, OCGenerateIvarsActionContext context2, String customName, Map ivarNames, OCInterfaceSymbol interfaceSymbol, OCImplementationSymbol implementationSymbol, PsiElement psiContext, PsiFile file2, Map newDeclarations, Map existingDeclarations, List synthesizes, OCNotReleasedIvarInspection.IvarsInfo ivarsInfo, List nonReleasedProperties, List nonReleasedIvarNames) {
        for (OCPropertySymbol property : properties) {
            if (!replaceAllProps && !defectiveCondition.value((Object)property)) continue;
            OCInstanceVariableSymbol associatedIvar = property.getAssociatedIvar(context2.getProject());
            String ivarName = customName != null ? customName : (associatedIvar != null ? associatedIvar.getName() : OCNameSuggester.getNonCollidingName(property, context2.getProject()));
            ivarNames.put(property, ivarName);
            CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

                protected boolean accept(OCInstanceVariableSymbol symbol) {
                    return symbol.getGeneratedFromProperty() == null;
                }
            };
            interfaceSymbol.processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, finder, context2.getProject());
            implementationSymbol.processMembers(ivarName, OCInstanceVariableSymbol.class, finder);
            OCType type = property.getResolvedType(OCResolveContext.forPsi(psiContext));
            if (!finder.isFound()) {
                ARCAttribute ivarAttribute;
                OCPropertySymbol.FlagAttribute propAttribute = property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)file2);
                String modifier = null;
                if (OCCompilerFeaturesHelper.isArcEnabled(file2) && type.isPointerToObjectCompatible() && !(ivarAttribute = propAttribute.getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
                newDeclarations.put(property, OCElementFactory.declaration(modifier, ivarName, property.getType(), psiContext));
            } else {
                existingDeclarations.put(property, finder.getFoundValue());
            }
            if (replaceAllProps) continue;
            String name = ivarName.equals(property.getName()) ? null : ivarName;
            OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", property.getName(), name, psiContext);
            synthesizes.add(synthesize);
            if (!type.isPointerToObjectCompatible() || !property.isRetained() || finder.isFound() && ivarsInfo != null && OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)finder.getFoundValue(), file2, ivarsInfo)) continue;
            nonReleasedProperties.add(property);
            nonReleasedIvarNames.add(ivarName);
        }
    }
}

