/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCOverrideImplementCppActionContext
extends OCCppActionContext<OCStructSymbol, OCFunctionSymbol> {
    private boolean myImplementMode;

    public OCOverrideImplementCppActionContext(OCStructSymbol parent, PsiElement context2, boolean implementMode) {
        super(parent, context2);
        this.myImplementMode = implementMode;
    }

    @Override
    @NotNull
    public Collection<OCFunctionSymbol> getMemberCandidates() {
        ArrayList<OCFunctionSymbol> result2 = new ArrayList<OCFunctionSymbol>();
        OCResolveContext context2 = OCResolveContext.forPsi(this.getContext());
        OCStructType.processMembersInBaseTypes((OCStructSymbol)this.getParent(), null, false, false, (Condition<? super OCSymbol>)((Condition)symbol -> {
            if (!(symbol instanceof OCFunctionSymbol)) {
                return false;
            }
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            if (!functionSymbol.isFriendOrStatic()) {
                String newName = OCCallableUtil.getOverridingFunctionName(functionSymbol, (OCSymbolWithQualifiedName)this.getParent());
                OCTypeEqualityVisitor equalityVisitor = new OCTypeEqualityVisitor(symbol.getResolvedType(context2), false, context2);
                Processor processor2 = existingSymbol -> {
                    if (!(existingSymbol instanceof OCFunctionSymbol)) {
                        return false;
                    }
                    return !equalityVisitor.isFunctionSignatureEqual(existingSymbol.getResolvedType(context2));
                };
                if (((OCStructSymbol)this.getParent()).processMembers(newName, (Processor<? super OCSymbol>)processor2) && (functionSymbol.getVisibility() != OCVisibility.PRIVATE || functionSymbol.isVirtual())) {
                    return true;
                }
            }
            return false;
        }), (Processor<? super OCSymbol>)((Processor)symbol -> {
            boolean isPureVirtual = ((OCFunctionSymbol)symbol).isPureVirtual();
            if ((!this.myImplementMode || isPureVirtual) && this.isValidOverride((OCFunctionSymbol)symbol)) {
                result2.add((OCFunctionSymbol)symbol);
            }
            return true;
        }), context2);
        return result2;
    }

    private boolean isValidOverride(@NotNull OCFunctionSymbol functionSymbol) {
        OCFunctionDeclaration funDecl;
        OCType functionType = functionSymbol.getType().getReturnType().getTerminalType();
        boolean validReturnType = true;
        if (functionType instanceof OCAutoType && (funDecl = functionSymbol.locateFunctionDefinition(this.getProject())) != null && funDecl.getTrailingReturnTypeElement() == null) {
            validReturnType = false;
        }
        return !functionSymbol.isFinal() && validReturnType;
    }
}

