/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMemberChooser
extends MemberChooser<OCMemberChooserObject> {
    private List<OCOption> myOptions;

    public OCMemberChooser(OCMemberChooserObject[] elements, boolean allowEmptySelection, boolean allowMultiSelection, List<Pair<OCOption, Object>> options2, @Nullable JComponent headerPanel, @NotNull Project project2) {
        super((ClassMember[])elements, allowEmptySelection, allowMultiSelection, project2, headerPanel, OCMemberChooser.createOptionComponents(options2));
        this.myOptions = ContainerUtil.map(options2, pair -> (OCOption)pair.getFirst());
    }

    protected boolean isContainerNode(MemberChooserObject key) {
        OCSymbol symbol = ((OCMemberChooserObject)key).getSymbol();
        return symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol;
    }

    protected boolean supportsNestedContainers() {
        return true;
    }

    protected void defaultExpandTree() {
        TreeUtil.expand((JTree)this.myTree, (int)2);
        for (int i2 = 0; i2 < this.myTree.getRowCount(); ++i2) {
            if (!(this.myTree.getPathForRow(i2).getLastPathComponent() instanceof MemberChooser.MemberNode)) continue;
            return;
        }
        super.defaultExpandTree();
    }

    protected void installSpeedSearch() {
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch(this.myTree, path -> {
            int i2;
            MemberChooser.ElementNode lastPathComponent;
            Object component = path.getLastPathComponent();
            MemberChooser.ElementNode elementNode = lastPathComponent = component instanceof MemberChooser.ElementNode ? (MemberChooser.ElementNode)component : null;
            if (lastPathComponent == null) {
                return null;
            }
            String text = lastPathComponent.getDelegate().getText();
            if (text != null && (i2 = text.indexOf(40)) >= 0) {
                text = text.substring(0, i2);
            }
            return text;
        }, true);
        treeSpeedSearch.setComparator(new SpeedSearchComparator(false));
    }

    private static JComponent[] createOptionComponents(List<Pair<OCOption, Object>> options2) {
        JComponent[] components = new JComponent[options2.size()];
        for (int i2 = 0; i2 < components.length; ++i2) {
            OCOption option = (OCOption)options2.get(i2).getFirst();
            components[i2] = option.createComponent();
            option.selectValue(components[i2], options2.get(i2).getSecond());
        }
        return components;
    }

    public Map<OCOption, Object> getOptionSelections() {
        HashMap<OCOption, Object> map2 = new HashMap<OCOption, Object>();
        for (int i2 = 0; i2 < this.myOptionControls.length; ++i2) {
            OCOption option = this.myOptions.get(i2);
            map2.put(option, option.getSelectedValue(this.myOptionControls[i2]));
        }
        return map2;
    }

    public <T, Comp extends JComponent> void setOptionSelection(OCOption<T, Comp> option, T value) {
        int i2 = this.myOptions.indexOf(option);
        if (i2 != -1) {
            option.selectValue(this.myOptionControls[i2], value);
        }
    }

    public <T, Comp extends JComponent> Comp getOptionComponent(OCOption<T, Comp> option) {
        return (Comp)this.myOptionControls[this.myOptions.indexOf(option)];
    }

    @Nullable
    public List<OCMemberChooserObject> getChosenElements() {
        return new ArrayList<OCMemberChooserObject>(this.mySelectedElements);
    }

    public void selectElements(ClassMember[] elements) {
        if (elements.length == 0 && ((OCMemberChooserObject[])this.myElements).length > 0) {
            super.selectElements(new ClassMember[]{((OCMemberChooserObject[])this.myElements)[0]});
        } else {
            super.selectElements(elements);
        }
    }
}

