/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.surround;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.surround.OCExpressionSurrounder;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public abstract class OCTextExpressionSurrounder
extends OCExpressionSurrounder {
    @Override
    public TextRange surroundExpression(@NotNull Project project2, @NotNull Editor editor, @NotNull OCExpression expr) throws IncorrectOperationException {
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        String surroundText = this.getBeforeText() + expr.getTextWithMacros() + this.getAfterText();
        OCExpression element = OCElementFactory.expressionFromText(surroundText, expr);
        if (element == null) {
            OCLog.LOG.error("wrong surround: ", new String[]{surroundText});
        } else {
            PsiElement reformatedExpr = codeStyleManager.reformat((PsiElement)element);
            if (!(reformatedExpr instanceof OCExpression)) {
                OCLog.LOG.error("wrong expression after format: ", new String[]{reformatedExpr.getText()});
            } else {
                expr = (OCExpression)expr.replace(reformatedExpr);
            }
        }
        int offset = expr.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    @NotNull
    protected abstract String getBeforeText();

    @NotNull
    protected abstract String getAfterText();
}

