/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.folding;

import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.OCFoldingBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MSPragmaCustomFoldingProvider
extends CustomFoldingProvider {
    private static final Pattern ourStart = Pattern.compile("#\\s*pragma*\\s*region(\\s+.*)?");
    private static final Pattern ourEnd = Pattern.compile("#\\s*pragma*\\s*endregion.*");

    public boolean isCustomRegionStart(@NotNull String elementText) {
        return ourStart.matcher(elementText).matches();
    }

    public boolean isCustomRegionEnd(@NotNull String elementText) {
        return ourEnd.matcher(elementText).matches();
    }

    public String getPlaceholderText(@NotNull String elementText) {
        String placeholder;
        Matcher matcher = ourStart.matcher(elementText);
        if (matcher.matches() && (placeholder = matcher.group(1)) != null && !(placeholder = placeholder.trim()).isEmpty()) {
            return placeholder;
        }
        return "...";
    }

    public boolean wrapStartEndMarkerTextInLanguageSpecificComment() {
        return false;
    }

    public boolean isSupportedBy(FoldingBuilder foldingBuilder) {
        return foldingBuilder instanceof OCFoldingBuilder;
    }

    @Nls
    public String getDescription() {
        return OCBundle.message("action.CIDR.Lang.Wrap.By.Pragma.Region", new Object[0]);
    }

    @NonNls
    public String getStartString() {
        return "#pragma region ?";
    }

    @NonNls
    public String getEndString() {
        return "#pragma endregion";
    }
}

