/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import org.jetbrains.annotations.NotNull;

public class PropertyInsertHandler
implements InsertHandler<LookupElement> {
    private final PsiElement myContextExpression;
    private final OCPropertySymbol myPropertySymbol;
    private final OCSymbolGroupContext mySymbolContext;

    public PropertyInsertHandler(PsiElement contextExpression, OCPropertySymbol propertySymbol, OCSymbolGroupContext symbolContext) {
        this.myContextExpression = contextExpression;
        this.myPropertySymbol = propertySymbol;
        this.mySymbolContext = symbolContext;
    }

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Object o = item.getObject();
        if (o instanceof OCSymbolNavigationItem && ((OCSymbolNavigationItem)o).getSymbol() instanceof OCPropertySymbol && !(this.myContextExpression instanceof OCQualifiedExpression) && (this.myContextExpression == null || !(this.myContextExpression.getParent() instanceof OCSynthesizeProperty))) {
            context2.getDocument().insertString(context2.getStartOffset(), (CharSequence)"self.");
            context2.setTailOffset(context2.getTailOffset() + 5);
        }
        if (this.myContextExpression instanceof OCQualifiedExpression) {
            PsiDocumentManager.getInstance((Project)context2.getProject()).commitDocument(context2.getDocument());
            OCImportSymbolFix.fixAfterCompletionAtCaret(context2.getEditor(), context2.getFile(), this.myPropertySymbol);
        }
    }
}

