/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCNewExpressionCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCSymbolsToLookupConverter;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCProtocolList;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCDefinedDirectiveImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCReferenceCompletionContributor
extends OCCompletionContributorBase {
    public static final PsiElementPattern.Capture<PsiElement> DECLARATOR_WITH_QUALIFIER = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).andNot(OCCompletionPatterns.AFTER_DOT)).withParent(OCDeclarator.class)).andOr(new ElementPattern[]{PlatformPatterns.psiElement().afterLeaf(new String[]{"::"}), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().with(OCCompletionPatterns.CPP_ELEMENT_PATTERN)).withSuperParent(3, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(OCCppNamespace.class), PlatformPatterns.psiElement(OCFile.class)}))})).andNot(OCCompletionPatterns.TYPE_IN_DECLARATION);
    public static final PsiElementPattern.Capture<PsiElement> DESTRUCTOR_DECLARATOR = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).andNot(OCCompletionPatterns.AFTER_DOT)).withParent(OCDeclarator.class)).and(OCCompletionPatterns.AFTER_TILDE);
    public static final PsiElementPattern.Capture<PsiElement> NESTED_NAMESPACE = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).afterLeaf(new String[]{"::"})).withParent(OCCppNamespace.class);
    public static final PsiElementPattern.Capture<PsiElement> REFERENCE_FRAGMENT = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent((ElementPattern)PlatformPatterns.psiElement((IElementType)OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT));
    private static boolean ourSuggestBuiltinMacrosInTests = false;
    private static final List<String> BUILT_IN_MACROS_EXPRESSION = Arrays.asList("__PRETTY_FUNCTION__", "__FUNCTION__", "__func__", "__DATE__", "__TIME__", "__TIMESTAMP__", "__FILE__", "__LINE__", "__COUNTER__", "__BASE_FILE__", "__EXCEPTIONS", "va_start", "va_end", "va_arg", "va_copy");
    private static final List<String> BUILT_IN_MACROS_IB = Arrays.asList("IBOutlet", "IBOutletCollection", "IBAction");
    private static final TokenSet IF_DIRECTIVES_WITH_CONDITION = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.IFDEF_DIRECTIVE, OCTokenTypes.IFNDEF_DIRECTIVE, OCTokenTypes.IF_DIRECTIVE, OCTokenTypes.ELIF_DIRECTIVE});

    public static OCSymbolGroupContext getSymbolContext(@NotNull PsiElement element, Project project2, int invocationCount, Ref<Condition<OCSymbol>> typeCondition) {
        OCSymbolGroupContext symbolContext = null;
        PsiElement parent = element.getParent();
        PsiFile file2 = element.getContainingFile().getOriginalFile();
        CLanguageKind languageKind = file2 instanceof OCFile ? ((OCFile)file2).getKind() : CLanguageKind.maxLanguage();
        OCSymbolGroupContext forcedSymbolContext = file2 instanceof OCCodeFragment ? ((OCCodeFragment)file2).getCompletionFilter() : null;
        OCDirective directive = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDirective.class});
        if (forcedSymbolContext != null) {
            symbolContext = forcedSymbolContext;
        } else if (directive != null) {
            symbolContext = OCSymbolGroupContext.MACRO_OR_UNDEF_OR_MACRO_PARAMETER_CONTEXT;
        } else if (element instanceof OCDeclarator) {
            symbolContext = OCSymbolGroupContext.union(OCSymbolGroupContext.typeContext(languageKind), OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
            OCDeclarator declarator = (OCDeclarator)element;
            if (declarator.getNamespaceQualifier() != null) {
                symbolContext.addSymbolContext(OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION);
                symbolContext.addSymbolContext(OCSymbolKind.FUNCTION_PREDECLARATION);
                symbolContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION);
                symbolContext.addSymbolContext(OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION);
            }
        } else if (element instanceof OCCppNamespace) {
            symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]);
            symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
        } else {
            OCReferenceElement refElement = (OCReferenceElement)element;
            if (parent instanceof OCReferenceExpression || parent instanceof OCTypeElement) {
                OCSymbolGroupContext refContext;
                symbolContext = new OCSymbolGroupContext("completion context", new OCSymbolKind[0]);
                if (!OCCodeInsightUtil.isInPlainOldC(parent)) {
                    symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE);
                    symbolContext.addSymbolContext(OCSymbolKind.NAMESPACE_ALIAS);
                }
                if ((refContext = refElement.getSymbolContext(true)) != null) {
                    symbolContext.addSymbolContexts(refContext.getSymbolContexts());
                    symbolContext.addSymbolContext(OCSymbolKind.INTERFACE);
                }
                if (invocationCount <= 1 && parent.getParent() instanceof OCSendMessageExpression) {
                    typeCondition.set(symbol -> {
                        if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.TYPEDEF) {
                            return false;
                        }
                        OCType type = symbol.getEffectiveType(project2).getTerminalType();
                        return !(type instanceof OCNumericType) && !(type instanceof OCVoidType);
                    });
                } else if (invocationCount <= 1 && parent instanceof OCExpression && !(parent.getParent() instanceof OCStatement)) {
                    typeCondition.set(symbol -> !(symbol.getEffectiveType(project2) instanceof OCVoidType));
                }
            } else if (parent instanceof OCStructLike) {
                if (invocationCount == 0) {
                    return symbolContext;
                }
                IElementType token = PsiTreeUtil.firstChild((PsiElement)parent).getNode().getElementType();
                OCSymbolKind kind = token == OCTokenTypes.ENUM_KEYWORD ? OCSymbolKind.ENUM : (token == OCTokenTypes.UNION_KEYWORD ? OCSymbolKind.UNION : OCSymbolKind.STRUCT);
                symbolContext = new OCSymbolGroupContext("struct like", kind);
            } else if (parent instanceof OCReferenceElement) {
                symbolContext = OCSymbolGroupContext.PROTOCOL_CONTEXT;
            } else if (parent instanceof OCProtocolList) {
                symbolContext = refElement.getSymbolContext();
                OCProtocolList list = (OCProtocolList)parent;
                HashSet<String> protocols = new HashSet<String>();
                for (OCReferenceElement ref : list.getProtocols()) {
                    protocols.add(ref.getName());
                }
                typeCondition.set(candidate -> !protocols.contains(candidate.getName()));
            } else {
                symbolContext = parent instanceof OCCppUsingStatement ? (((OCCppUsingStatement)parent).isNamespaceUsing() ? new OCSymbolGroupContext(OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS) : null) : OCSymbolGroupContext.union(refElement.getSymbolContext(), OCSymbolKind.NAMESPACE, OCSymbolKind.NAMESPACE_ALIAS);
            }
        }
        if (symbolContext != null && forcedSymbolContext == null) {
            symbolContext.addSymbolContext(OCSymbolKind.MACRO);
        }
        return symbolContext;
    }

    public static OCQualifiedName getQualifierName(@NotNull PsiElement element) {
        OCCppNamespaceQualifier qualifier;
        OCSymbolWithQualifiedName symbol;
        PsiElement parent = element.getParent();
        OCQualifiedName qualifierName = element instanceof OCReferenceElement ? OCSymbolReferenceResolver.getQualifiedName((OCReferenceElement)element).getQualifier() : (element instanceof OCCppNamespace && parent instanceof OCCppNamespace ? ((symbol = (OCSymbolWithQualifiedName)((OCCppNamespace)parent).getSymbol()) != null ? symbol.getQualifiedName() : null) : ((qualifier = (OCCppNamespaceQualifier)PsiTreeUtil.getChildOfType((PsiElement)element, OCCppNamespaceQualifier.class)) != null ? OCSymbolReferenceResolver.getQualifiedName(qualifier) : null));
        return qualifierName;
    }

    public static void addNonImportedResults(@NotNull PsiElement element, OCSymbolGroupContext symbolContext, OCSymbolsToLookupConverter.ConverterState names, Project project2, int currentInvocationCount, OCQualifiedName qualifiedName, OCResolveContext resolveContext, OCSymbolsToLookupConverter processor2, Ref<Condition<OCSymbol>> typeCondition, CompletionResultSet result2, boolean addOnlyNonImported) {
        if (currentInvocationCount <= 1) {
            result2.addLookupAdvertisement(OCBundle.message("completion.press.keyboard.shortcut.for.non.imported.symbols", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
        }
        OCSymbolReference.LocalReference qualifierRef = OCSymbolReference.getLocalReference(qualifiedName, element);
        OCResolveContext incompleteContext = resolveContext.clone();
        incompleteContext.setIncompleteMode(true);
        if (!addOnlyNonImported) {
            qualifierRef.processPossibleSymbols(processor2, incompleteContext);
        }
        if (currentInvocationCount > 1) {
            OCSymbolsToLookupConverter converter;
            Condition oldCondition = (Condition)typeCondition.get();
            typeCondition.set(symbol -> {
                if (oldCondition != null && !oldCondition.value(symbol)) {
                    return false;
                }
                OCFile containingOCFile = symbol.getContainingOCFile(element.getProject());
                return containingOCFile != null && containingOCFile.isHeader();
            });
            if (addOnlyNonImported) {
                resolveContext.setProcessNonImported(false);
                List<OCSymbol> onlyImported = resolveContext.resolveToSymbols(qualifierRef);
                HashSet<String> ignoreNames = new HashSet<String>();
                onlyImported.forEach(symbol -> ignoreNames.add(symbol.getName()));
                converter = OCSymbolsToLookupConverter.createLookupConverter(symbolContext, names, result2, false, element, (Condition<OCSymbol>)((Condition)typeCondition.get()), project2, ignoreNames);
            } else {
                converter = OCSymbolsToLookupConverter.createLookupConverter(symbolContext, names, result2, false, element, (Condition<OCSymbol>)((Condition)typeCondition.get()), project2);
            }
            resolveContext.setProcessNonImported(true);
            List<OCSymbol> symbols = resolveContext.resolveToSymbols(qualifierRef);
            ContainerUtil.process(symbols, (Processor)converter);
            converter.finish();
        }
    }

    public OCReferenceCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context2, CompletionResultSet result2) {
                boolean isQualifiedIdFragment;
                PsiElement element = parameters.getPosition().getParent();
                int invocationCount = Math.min(parameters.getInvocationCount(), 2);
                boolean bl = isQualifiedIdFragment = OCElementUtil.getElementType(element) == OCElementTypes.QUALIFIED_ID_CODE_FRAGMENT;
                if (!(element instanceof OCReferenceElement || element instanceof OCDeclarator || element instanceof OCCppNamespace || isQualifiedIdFragment)) {
                    return;
                }
                if (MethodSelectorCompletionContributor.getMethodReceiverExpression(element) != null) {
                    return;
                }
                PsiFile file2 = element.getContainingFile().getOriginalFile();
                OCSymbolGroupContext forcedSymbolContext = file2 instanceof OCCodeFragment ? ((OCCodeFragment)file2).getCompletionFilter() : null;
                OCSymbolsToLookupConverter.ConverterState names = new OCSymbolsToLookupConverter.ConverterState();
                OCStatement stmt = (OCStatement)PsiTreeUtil.getParentOfType((PsiElement)element, OCStatement.class);
                Ref typeCondition = Ref.create();
                PsiElement parent = element.getParent();
                OCDirective directive = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCDirective.class});
                OCResolveContext resolveContext = OCResolveContext.forPsi(element);
                Project project2 = parameters.getPosition().getProject();
                OCSymbolGroupContext symbolContext = OCReferenceCompletionContributor.getSymbolContext(element, project2, invocationCount, (Ref<Condition<OCSymbol>>)typeCondition);
                if (parent instanceof OCExpression) {
                    OCType expectedType = OCExpectedTypeUtil.getExpectedType((OCExpression)parent, resolveContext).resolve(resolveContext);
                    if (expectedType instanceof OCBlockPointerType) {
                        result2.addElement(OCSmartCompletionContributor.createBlockTemplateElement((OCBlockPointerType)expectedType, element));
                    } else if (expectedType.getName().equals("SEL")) {
                        OCSmartCompletionContributor.addSelectorCompletions(result2, (OCExpression)parent);
                    }
                }
                if (forcedSymbolContext == null && directive != null) {
                    OCDefinedDirectiveImpl defined;
                    IElementType prevType = directive.getHeaderToken().getNode().getElementType();
                    if ((prevType == OCTokenTypes.IF_DIRECTIVE || prevType == OCTokenTypes.ELIF_DIRECTIVE) && (defined = (OCDefinedDirectiveImpl)PsiTreeUtil.getParentOfType((PsiElement)element, OCDefinedDirectiveImpl.class)) == null) {
                        result2.addElement((LookupElement)TemplateInsertHandler.lookup("defined").withTailText("()", true).withInsertHandler((InsertHandler)ParenthesesInsertHandler.getInstance((boolean)true)).bold());
                    }
                    if (IF_DIRECTIVES_WITH_CONDITION.contains(prevType)) {
                        OCSymbolsToLookupConverter processor2 = new OCSymbolsToLookupConverter(symbolContext, names, result2, true, element, null, project2);
                        OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
                        OCReferenceCompletionContributor.processBuiltinMacros(Collections.singletonList("__cplusplus"), inclusionContext, (Processor<OCSymbol>)processor2);
                    }
                } else if (element instanceof OCDeclarator) {
                    OCDeclarator declarator = (OCDeclarator)element;
                    if (OCCompletionPatterns.AFTER_TILDE.accepts((Object)declarator.getNameIdentifier())) {
                        PsiElement grandpa = element.getParent().getParent();
                        if (grandpa instanceof OCStructLike && declarator.getNamespaceQualifier() == null) {
                            result2.addElement((LookupElement)TemplateInsertHandler.lookup(((OCStructLike)grandpa).getName() + "()").bold().withTailText("()"));
                            return;
                        }
                        result2 = result2.withPrefixMatcher("~" + result2.getPrefixMatcher().getPrefix());
                    }
                } else if (parent instanceof OCStructLike && symbolContext == null) {
                    return;
                }
                if (symbolContext != null && forcedSymbolContext == null) {
                    symbolContext.addSymbolContext(OCSymbolKind.MACRO);
                }
                Condition accessibilityCondition = element instanceof OCDeclarator ? null : symbol -> OCVisibility.isVisible(symbol, element, null, project2);
                Condition merge = OCReferenceCompletionContributor.merge((Condition<OCSymbol>)((Condition)typeCondition.get()), (Condition<OCSymbol>)accessibilityCondition);
                OCSymbolsToLookupConverter processor3 = OCSymbolsToLookupConverter.createLookupConverter(symbolContext, names, result2, true, element, (Condition<OCSymbol>)merge, project2);
                OCQualifiedName qualifierName = OCReferenceCompletionContributor.getQualifierName(element);
                for (int i2 = invocationCount; i2 <= 2; ++i2) {
                    OCQualifiedName qualifiedName;
                    if (qualifierName != null) {
                        qualifiedName = OCQualifiedName.with(qualifierName, null);
                    } else {
                        qualifiedName = OCQualifiedName.with(null);
                        if (element instanceof OCReferenceElement) {
                            OCThisSelfSuperSymbol.processThisSelfSuperInContext((OCReferenceElement)element, processor3, false);
                        }
                        if (parent instanceof OCCppUsingStatement && !((OCCppUsingStatement)parent).isNamespaceUsing()) {
                            result2.addElement(OCCompletionPriority.keywordWithPriority("namespace ", OCCompletionPriority.NORMAL_KEYWORDS_PRIORITY));
                        }
                        if (forcedSymbolContext == null) {
                            OCImmutableInclusionContext inclusionContext = OCInclusionContextUtil.headerContext(file2);
                            if (stmt instanceof OCDeclarationStatement || stmt instanceof OCExpressionStatement) {
                                OCReferenceCompletionContributor.processBuiltinMacros(BUILT_IN_MACROS_EXPRESSION, inclusionContext, (Processor<OCSymbol>)processor3);
                            }
                            if (symbolContext == null || symbolContext.isSuitableSymbolKind(OCSymbolKind.INTERFACE)) {
                                OCReferenceCompletionContributor.processBuiltinMacros(BUILT_IN_MACROS_IB, inclusionContext, (Processor<OCSymbol>)processor3);
                            }
                        }
                    }
                    result2.addLookupAdvertisement(OCBundle.message("completion.press.keyboard.shortcut.to.filter.results.by.type", KeymapUtil.getFirstKeyboardShortcutText((String)"SmartTypeCompletion")));
                    if ("_".equals(prefix) && i2 <= 1 && !(parent instanceof OCStructLike)) {
                        if (i2 == 1) {
                            result2.addLookupAdvertisement(OCBundle.message("completion.press.keyboard.shortcut.for.global.symbols", KeymapUtil.getFirstKeyboardShortcutText((String)"CodeCompletion")));
                        }
                        OCResolveUtil.processLocalAndMemberSymbols(null, element, processor3);
                    } else {
                        OCReferenceCompletionContributor.addNonImportedResults(element, symbolContext, names, project2, i2, qualifiedName, resolveContext, processor3, (Ref<Condition<OCSymbol>>)typeCondition, result2, false);
                    }
                    processor3.finish();
                    if (!processor3.isEmpty()) break;
                    typeCondition.set(null);
                }
            }
        };
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)((PsiElementPattern.Capture)((PsiElementPattern.Capture)OCCompletionPatterns.REFERENCE_ELEMENT.andNot(OCCompletionPatterns.AFTER_DOT)).andNot(OCCompletionPatterns.AT_CLASS_FUNCTION_BODY_PLACEHOLDER)).andNot(OCNewExpressionCompletionContributor.TYPE_IN_NEW_EXPRESSION), provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.TYPE_IN_DECLARATION.andNot(OCCompletionPatterns.AFTER_DOT), provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)DECLARATOR_WITH_QUALIFIER, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)DESTRUCTOR_DECLARATOR, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)NESTED_NAMESPACE, provider2);
        this.register(CompletionType.BASIC, (ElementPattern<? extends PsiElement>)REFERENCE_FRAGMENT, provider2);
    }

    private static Condition<OCSymbol> merge(Condition<OCSymbol> c1, Condition<OCSymbol> c2) {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return symbol -> c1.value(symbol) && c2.value(symbol);
    }

    private static void processBuiltinMacros(@NotNull List<String> macros, @NotNull OCImmutableInclusionContext inclusionContext, @NotNull Processor<OCSymbol> result2) {
        if (ApplicationManager.getApplication().isUnitTestMode() && ourSuggestBuiltinMacrosInTests != Boolean.TRUE) {
            return;
        }
        for (String each : macros) {
            OCMacroSymbol macro = inclusionContext.getDefinition(each);
            if (macro == null) continue;
            result2.process((Object)macro);
        }
    }

    public static void setSuggestBuiltInMacrosInTests(boolean suggest) {
        ourSuggestBuiltinMacrosInTests = suggest;
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        IElementType prevType = position.getNode().getElementType();
        if ('>' == typeChar && ((Object)((Object)OCTokenTypes.MINUS)).equals(prevType)) {
            return true;
        }
        if (':' == typeChar && ((Object)((Object)OCTokenTypes.COLON)).equals(prevType) && !(position.getParent() instanceof OCSelectorExpression)) {
            return true;
        }
        PsiFile containingFile = position.getContainingFile();
        return '*' == typeChar && (((Object)((Object)OCTokenTypes.DEREF)).equals(prevType) || ((Object)((Object)OCTokenTypes.DOT)).equals(prevType)) && containingFile instanceof OCFile && FileSymbolTablesCache.areSymbolsLoaded(position.getProject()) && ((OCFile)containingFile).getKind().isCpp();
    }
}

