/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.editor.completion.FunctionDeclarationInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.FunctionInsertHandler;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CallableInsertUtils {
    public static final Key<Boolean> ENABLED_PLACEHOLDERS_IN_TESTS = Key.create((String)"ENABLED_PLACEHOLDERS_IN_TESTS");

    public static void moveCaretToCallableBody(InsertionContext context2) {
        Document document2 = context2.getDocument();
        Editor editor = context2.getEditor();
        CodeFoldingManager foldManager = CodeFoldingManager.getInstance((Project)context2.getProject());
        foldManager.updateFoldRegions(editor);
        String documentText = document2.getText();
        int bodyStart = documentText.indexOf("{", context2.getStartOffset());
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context2.getProject());
        pdm.commitDocument(document2);
        PsiFile file2 = pdm.getPsiFile(document2);
        if (file2 != null) {
            PsiElement leaf = file2.findElementAt(bodyStart);
            OCBlockStatement body = (OCBlockStatement)PsiTreeUtil.getContextOfType((PsiElement)leaf, (boolean)false, (Class[])new Class[]{OCBlockStatement.class});
            OCCodeInsightUtil.selectBody(editor, body);
        }
    }

    @NotNull
    public static InsertHandler<LookupElement> createHandler(@NotNull OCFunctionSymbol symbol, @Nullable PsiElement contextExpression, @NotNull Project project2) {
        if (contextExpression instanceof OCDeclarator) {
            FunctionDeclarationInsertHandler handler = new FunctionDeclarationInsertHandler(symbol);
            handler.calculateInsertion(OCResolveContext.forPsi(contextExpression));
            return handler;
        }
        FunctionInsertHandler handler = new FunctionInsertHandler(symbol, contextExpression);
        handler.calculateInsertion(contextExpression != null ? OCResolveContext.forPsi(contextExpression) : OCResolveContext.forSymbol(symbol, project2));
        return handler;
    }

    public static boolean isReplaceCompletionBeforeParen(@NotNull InsertionContext context2) {
        boolean tabBeforePar = false;
        if (CallableInsertUtils.isReplaceCompletion(context2)) {
            CharSequence chars = context2.getDocument().getCharsSequence();
            tabBeforePar = chars.length() > context2.getTailOffset() && chars.charAt(context2.getTailOffset()) == '(';
        }
        return tabBeforePar;
    }

    public static boolean isReplaceCompletion(@NotNull InsertionContext context2) {
        return context2.getCompletionChar() == '\t';
    }

    public static void addKernel(@NotNull InsertionContext context2) {
        Document document2 = context2.getDocument();
        context2.commitDocument();
        document2.insertString(context2.getTailOffset(), (CharSequence)"<<<>>>");
    }

    public static void addParensIfRequired(@NotNull InsertionContext context2, @NotNull LookupElement item, boolean hasParams) {
        CommonCodeStyleSettings styleSettings = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context2);
        ParenthesesInsertHandler.getInstance((boolean)hasParams, (boolean)styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, (styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams ? 1 : 0) != 0, (boolean)true, (boolean)styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).handleInsert(context2, item);
    }

    public static boolean shouldInsertPlaceholders(@NotNull InsertionContext context2) {
        if (ApplicationManager.getApplication().isUnitTestMode() ? context2.getProject().getUserData(ENABLED_PLACEHOLDERS_IN_TESTS) == Boolean.FALSE : !PlatformUtils.isAppCode()) {
            return false;
        }
        Document document2 = context2.getDocument();
        int offset = context2.getEditor().getCaretModel().getOffset();
        return offset < document2.getTextLength() && document2.getCharsSequence().charAt(offset) == ')';
    }

    public static void selectFirstPlaceholderIfPresent(@NotNull InsertionContext context2) {
        Editor editor = context2.getEditor();
        Project project2 = context2.getProject();
        context2.commitDocument();
        String documentText = context2.getDocument().getText();
        int firstParamStart = documentText.indexOf("<#", context2.getStartOffset());
        int firstParamEnd = documentText.indexOf("#>", firstParamStart);
        SelectionModel selectionModel = editor.getSelectionModel();
        if (firstParamStart >= 0 && firstParamEnd >= 0 && firstParamStart < context2.getTailOffset()) {
            selectionModel.setSelection(firstParamStart, firstParamEnd + 2);
        }
        OCChangeUtil.reformatTextIfNotInjected(context2.getFile(), context2.getStartOffset(), context2.getTailOffset());
        CodeFoldingManager.getInstance((Project)project2).updateFoldRegions(editor);
    }
}

