/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    public ASTNode generateWhitespaceBetweenTokens(@Nullable ASTNode left, @Nullable ASTNode right) {
        if (right != null && OCFormatterUtil.FORMAT_DIRECTIVES.contains(right.getElementType())) {
            return OCTokenSeparatorGenerator.createLineBreak(right.getTreeParent().getPsi().getManager());
        }
        if (left != null && (left.getElementType() == OCTokenTypes.EOL_COMMENT || left.getElementType() == OCTokenTypes.EOL_ESCAPE)) {
            return OCTokenSeparatorGenerator.createLineBreak(left.getTreeParent().getPsi().getManager());
        }
        if (OCTokenSeparatorGenerator.mustSpaceInFunctionEnd(left, right)) {
            return OCTokenSeparatorGenerator.createSpace(right.getTreeParent().getPsi().getManager());
        }
        return null;
    }

    @NotNull
    private static ASTNode createSpace(PsiManager manager2) {
        return OCTokenSeparatorGenerator.createWhitespace(manager2, " ");
    }

    @NotNull
    private static ASTNode createLineBreak(PsiManager manager2) {
        return OCTokenSeparatorGenerator.createWhitespace(manager2, "\n");
    }

    @NotNull
    private static ASTNode createWhitespace(PsiManager manager2, String text) {
        return Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)text, (int)0, (int)text.length(), null, (PsiManager)manager2);
    }

    @Contract(value="null, _ -> false; _, null -> false")
    public static boolean mustSpaceInFunctionEnd(@Nullable ASTNode left, @Nullable ASTNode right) {
        if (left == null || right == null || !left.getPsi().isValid() || !right.getPsi().isValid()) {
            return false;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)left.getPsi(), (PsiElement)right.getPsi());
        if (!(commonParent instanceof OCFunctionDeclaration)) {
            return false;
        }
        OCParameterList parameterList = ((OCFunctionDeclaration)commonParent).getParameterList();
        if (parameterList == null || parameterList.getTextOffset() > right.getStartOffset()) {
            return false;
        }
        return OCTokenSeparatorGenerator.needSpaceInTheEndOfFunctionSig(OCElementUtil.getElementType(right), OCElementUtil.getElementType(left));
    }

    @Contract(pure=true)
    public static boolean needSpaceInTheEndOfFunctionSig(@NotNull IElementType typeRight, @NotNull IElementType typeLeft) {
        return typeRight == OCTokenTypes.EQ || typeLeft == OCTokenTypes.EQ && (typeRight == OCElementTypes.LITERAL_EXPRESSION || typeRight == OCTokenTypes.DEFAULT_KEYWORD || typeRight == OCTokenTypes.DELETE_CPP_KEYWORD) || typeRight == OCTokenTypes.CONST_KEYWORD || typeRight == OCTokenTypes.VOLATILE_KEYWORD || typeRight == OCTokenTypes.OVERRIDE_CPP_KEYWORD || typeRight == OCTokenTypes.FINAL_CPP_KEYWORD || typeRight == OCElementTypes.CPP_EXCEPTION_SPECIFICATION || typeRight == OCElementTypes.CPP_NOEXCEPT_SPECIFIER;
    }
}

