/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements ParameterInfoHandler<PsiElement, FunctionInfoWrapper> {
    public static final Logger LOG = Logger.getInstance(OCFunctionParameterInfoHandler.class);
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    public boolean couldShowInLookup() {
        return false;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context2) {
        throw new UnsupportedOperationException();
    }

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context2) {
        int startOffset;
        int offset;
        PsiFile file2 = context2.getFile();
        OCFunctionCallPlace<?> callPlace = OCFunctionParameterInfoHandler.findCallPlace(file2, offset = context2.getOffset(), startOffset = context2.getParameterListStart());
        if (callPlace != null) {
            ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
            callPlace.collectCallOptions(callOptions);
            callOptions.sort((o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
            ArrayList<FunctionInfoWrapper> overloads = new ArrayList<FunctionInfoWrapper>();
            OCResolveContext resolveContext = OCResolveContext.forPsi(callPlace.getElement());
            block0: for (OCFunctionCallOption option : callOptions) {
                OCFunctionParameterInfo info = option.getParameterInfo();
                OCFunctionType funcType = info.getType();
                for (int i2 = 0; i2 < overloads.size(); ++i2) {
                    FunctionInfoWrapper other = (FunctionInfoWrapper)overloads.get(i2);
                    OCFunctionType otherType = other.getInfo().getType();
                    if (!otherType.equalsAfterResolving(funcType, resolveContext)) continue;
                    if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                    overloads.set(i2, new FunctionInfoWrapper(info));
                    continue block0;
                }
                overloads.add(new FunctionInfoWrapper(info));
            }
            context2.setItemsToShow(overloads.toArray());
        }
        return callPlace == null ? null : (PsiElement)callPlace.getElement();
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names = funcType.getParameterNames();
        if (names == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace<?> findCallPlace(PsiFile file2, int offset, int startOffset) {
        if (file2 == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file2.findElementAt(offset);
        PsiElement e2 = file2.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@NotNull PsiElement element) {
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context2) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context2.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context2) {
        OCFunctionCallPlace<?> place = OCFunctionParameterInfoHandler.findCallPlace(context2.getFile(), context2.getOffset(), context2.getParameterListStart());
        return place == null ? null : (PsiElement)place.getElement();
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context2) {
        OCFunctionCallPlace<? extends PsiElement> callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner);
        OCLog.LOG.assertTrue(callPlace != null);
        int offset = context2.getOffset();
        if (!parameterOwner.getTextRange().contains(offset)) {
            context2.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        context2.setCurrentParameter(index);
        Object[] methods = context2.getObjectsToView();
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            FunctionInfoWrapper wrapper = (FunctionInfoWrapper)methods[i2];
            OCFunctionType funcType = wrapper.getInfo().getType();
            boolean isEnabled = OCFunctionParameterInfoHandler.isApplicableBeforeIndex(funcType, argExpressions, index);
            context2.setUIComponentEnabled(i2, isEnabled);
            wrapper.ui = OCFunctionParameterInfoHandler.calcUI(wrapper.getInfo(), index, isEnabled, parameterOwner);
        }
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCType argType;
            OCType paramType = params.get(j);
            OCExpression arg = args.get(j);
            if (arg == null || !paramType.checkCompatible(argType = arg.getResolvedType(), arg, arg, OCResolveContext.forPsi(arg)).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public void updateUI(@NotNull FunctionInfoWrapper wrapper, @NotNull ParameterInfoUIContext context2) {
        PsiElement owner = context2.getParameterOwner();
        if (owner != null) {
            OCFunctionParameterInfoHandler.updateFunctionUI(wrapper.ui, context2);
        }
    }

    private static FunctionInfoWrapper.UI calcUI(@NotNull OCFunctionParameterInfo info, int currentParameter, boolean isEnabled, @NotNull PsiElement context2) {
        int commaStart;
        StringBuilder buffer = new StringBuilder();
        OCFunctionType type = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type.getParameterTypes();
        @Nullable List<String> paramNames = type.getParameterNames();
        String paramTypeHint = null;
        if ((context2 instanceof OCArgumentList || context2 instanceof OCParameterList) && context2.getParent() instanceof OCDeclarator && (paramTypeHint = ((OCDeclarator)context2.getParent()).getType().getBestNameInContext(context2)) != null && (commaStart = paramTypeHint.indexOf(40)) != -1) {
            paramTypeHint = paramTypeHint.substring(0, commaStart);
        }
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i2 = 0; i2 < numParams; ++i2) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i2).getBestNameInContext(context2, paramTypeHint);
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i2);
                String defValue = defParamValues == null ? null : defParamValues.get(i2);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i2 < numParams - 1) {
                    buffer.append(", ");
                }
                if (!isEnabled || i2 != currentParameter && (i2 != numParams - 1 || !type.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return new FunctionInfoWrapper.UI(buffer.toString(), highlightStartOffset, highlightEndOffset);
    }

    public static String updateFunctionUI(@NotNull FunctionInfoWrapper.UI ui, ParameterInfoUIContext context2) {
        return context2.setupUIComponentPresentation(ui.text, ui.highlightStartOffset, ui.highlightEndOffset, !context2.isUIComponentEnabled(), false, false, context2.getDefaultParameterColor());
    }

    public static class FunctionInfoWrapper {
        @NotNull
        private final OCFunctionParameterInfo myInfo;
        @NotNull
        private UI ui = new UI("", -1, -1);

        public FunctionInfoWrapper(@NotNull OCFunctionParameterInfo info) {
            this.myInfo = info;
        }

        @NotNull
        public OCFunctionParameterInfo getInfo() {
            return this.myInfo;
        }

        @NotNull
        public UI getUi() {
            return this.ui;
        }

        public void setUi(@NotNull UI ui) {
            this.ui = ui;
        }

        public static class UI {
            @NotNull
            public final String text;
            public final int highlightStartOffset;
            public final int highlightEndOffset;

            private UI(@NotNull String text, int highlightStartOffset, int highlightEndOffset) {
                this.text = text;
                this.highlightStartOffset = highlightStartOffset;
                this.highlightEndOffset = highlightEndOffset;
            }
        }
    }
}

