/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.documentation.HtmlHelper;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoxygenRender {
    private static final Map<String, String> TAG_TABLE = new HashMap<String, String>();
    @Nullable
    private final DoxygenCommentGroup docComment;

    @NotNull
    private static String extractName(@NotNull String name) {
        if (TAG_TABLE.containsKey(name)) {
            return TAG_TABLE.get(name);
        }
        if (!name.isEmpty()) {
            return StringUtil.toUpperCase((String)name.substring(0, 1)) + name.substring(1);
        }
        return name;
    }

    public DoxygenRender(@NotNull PsiElement element) {
        this.docComment = DoxygenFacade.getCommentGroup(element);
    }

    public boolean hasDoxygenComments() {
        return this.docComment != null && !this.docComment.isEmpty();
    }

    public void render(@NotNull StringBuilder answer) {
        if (this.docComment == null) {
            return;
        }
        HtmlHelper.HtmlDoc html = new HtmlHelper.HtmlDoc();
        StringBuilder content = new StringBuilder();
        String options2 = this.docComment.getOptions();
        if (!options2.isEmpty()) {
            content.append(HtmlHelper.code(options2)).append(" ");
        }
        List<InfoItem> items = DoxygenRender.squash(this.docComment.getContent());
        Runnable finalizeContent = () -> {
            if (content.length() != 0) {
                html.addText(HtmlHelper.paragraph(content.toString()));
                content.setLength(0);
            }
        };
        for (InfoItem item : items) {
            if (item instanceof CompositeInfoItem) {
                finalizeContent.run();
                DoxygenRender.renderCompositeItem(answer, html, (CompositeInfoItem)item);
                continue;
            }
            if (item instanceof TagItem && DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(((TagItem)item).getName())) {
                DoxygenRender.processFormatTag((TagItem)item, (Consumer<String>)((Consumer)text -> content.append((String)text)));
                continue;
            }
            content.append(item.getDescription());
        }
        finalizeContent.run();
        answer.append(html.toString());
    }

    private static void renderCompositeItem(@NotNull StringBuilder answer, @NotNull HtmlHelper.HtmlDoc html, @NotNull CompositeInfoItem composite) {
        String name = composite.getName();
        if (DoxygenCmd.BRIEF.toString().equals(name)) {
            StringBuilder content = new StringBuilder();
            Runnable finalizeContent = () -> {
                if (content.length() != 0) {
                    answer.append(HtmlHelper.newLine(content.toString()));
                    content.setLength(0);
                }
            };
            for (TagItem tag : composite.getTags()) {
                if (DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(tag.getName())) {
                    DoxygenRender.processFormatTag(tag, (Consumer<String>)((Consumer)text -> content.append((String)text)));
                    continue;
                }
                boolean lineStarter = content.length() == 0;
                content.append(tag.getDescription());
                if (lineStarter) continue;
                finalizeContent.run();
            }
            finalizeContent.run();
        } else if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            for (TagItem tag : composite.getTags()) {
                String description2 = tag.getDescription();
                html.addText(HtmlHelper.pre(HtmlHelper.code(description2)));
            }
        } else {
            HtmlHelper.DL descriptionList = new HtmlHelper.DL();
            descriptionList.defineTerm(HtmlHelper.bold(DoxygenRender.extractName(name)));
            HtmlHelper.Table table = new HtmlHelper.Table();
            Ref row = Ref.create();
            StringBuilder content = new StringBuilder();
            Runnable finalizeContent = () -> {
                HtmlHelper.TableRow _row = (HtmlHelper.TableRow)row.get();
                if (_row != null) {
                    _row.addData(content.toString());
                    table.addRow(_row);
                    row.set(null);
                    content.setLength(0);
                }
            };
            for (TagItem tag : composite.getTags()) {
                boolean isFormatTag = DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(tag.getName());
                if (!isFormatTag) {
                    finalizeContent.run();
                }
                if (row.get() == null) {
                    row.set((Object)HtmlHelper.TableRow.withData(HtmlHelper.code(tag.getOptions())));
                    List<String> parameters = tag.getParameters();
                    if (!parameters.isEmpty()) {
                        ((HtmlHelper.TableRow)row.get()).addData(HtmlHelper.bold(StringUtil.join(parameters, (String)", ")));
                    }
                }
                if (isFormatTag) {
                    DoxygenRender.processFormatTag(tag, (Consumer<String>)((Consumer)text -> content.append((String)text)));
                    continue;
                }
                for (InfoItem item : tag.getContent()) {
                    String description3 = item.getDescription();
                    if (item instanceof TagItem && DoxygenCmd.SURROUND_TAGS.containsKey(((TagItem)item).getName())) {
                        content.append(HtmlHelper.pre(HtmlHelper.code(description3)));
                        continue;
                    }
                    content.append(description3);
                }
            }
            finalizeContent.run();
            descriptionList.detailedDescription(table);
            html.addItem(descriptionList);
        }
    }

    private static void processFormatTag(@NotNull TagItem item, @NotNull Consumer<String> addDescription) {
        String nextWordWrapTag = DoxygenCmd.FORMAT_NEXT_WORD_TAGS.get(item.getName());
        assert (nextWordWrapTag != null);
        String description2 = item.getDescription();
        int spacePos = StringUtil.indexOfAny((String)description2, (String)" \n\r\t");
        addDescription.consume((Object)" ");
        if (spacePos >= 0) {
            addDescription.consume((Object)HtmlHelper.wrapWithTag(nextWordWrapTag, description2.substring(0, spacePos)));
            addDescription.consume((Object)description2.substring(spacePos));
        } else {
            addDescription.consume((Object)HtmlHelper.wrapWithTag(nextWordWrapTag, description2));
        }
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items) {
        return DoxygenRender.squash(items, 0, null);
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items, int position, @Nullable CompositeInfoItem compositeItem) {
        ArrayList<InfoItem> blocks = new ArrayList<InfoItem>();
        if (position < items.size()) {
            InfoItem item = items.get(position);
            if (item instanceof TagItem) {
                TagItem tag = (TagItem)item;
                String name = tag.getName();
                if (!DoxygenCmd.PARAM.toString().equals(name) || !tag.getParameters().isEmpty()) {
                    if (compositeItem != null && (name.equals(compositeItem.getName()) || DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(name))) {
                        compositeItem.addItem(tag);
                    } else if (DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(name)) {
                        blocks.add(item);
                    } else {
                        compositeItem = new CompositeInfoItem(tag);
                        blocks.add(compositeItem);
                    }
                }
            } else {
                compositeItem = null;
                blocks.add(item);
            }
            List<InfoItem> result2 = DoxygenRender.squash(items, ++position, compositeItem);
            blocks.addAll(result2);
        }
        return blocks;
    }

    static {
        TAG_TABLE.put(DoxygenCmd.ATTENTION.toString(), "Attention");
        TAG_TABLE.put(DoxygenCmd.AUTHOR.toString(), "Author");
        TAG_TABLE.put(DoxygenCmd.AUTHORS.toString(), "Authors");
        TAG_TABLE.put(DoxygenCmd.BUG.toString(), "Bug");
        TAG_TABLE.put(DoxygenCmd.COPYRIGHT.toString(), "Copyright");
        TAG_TABLE.put(DoxygenCmd.DATE.toString(), "Date");
        TAG_TABLE.put(DoxygenCmd.DEPRECATED.toString(), "Deprecated");
        TAG_TABLE.put(DoxygenCmd.INVARIANT.toString(), "Invariant");
        TAG_TABLE.put(DoxygenCmd.PARAM.toString(), "Parameters");
        TAG_TABLE.put(DoxygenCmd.TPARAM.toString(), "Template Parameters");
        TAG_TABLE.put(DoxygenCmd.PRE.toString(), "Precondition");
        TAG_TABLE.put(DoxygenCmd.POST.toString(), "Postcondition");
        TAG_TABLE.put(DoxygenCmd.REMARK.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.REMARKS.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.SA.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SEE.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SINCE.toString(), "Since");
        TAG_TABLE.put(DoxygenCmd.TODO.toString(), "Todo");
        TAG_TABLE.put(DoxygenCmd.VERSION.toString(), "Version");
        TAG_TABLE.put(DoxygenCmd.WARNING.toString(), "Warning");
        TAG_TABLE.put(DoxygenCmd.RETURN.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETURNS.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RESULT.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETVAL.toString(), "Return values");
        TAG_TABLE.put(DoxygenCmd.THROW.toString(), "Exceptions");
        TAG_TABLE.put(DoxygenCmd.THROWS.toString(), "Exceptions");
        TAG_TABLE.put("exception", "Exceptions");
    }

    private static class CompositeInfoItem
    implements InfoItem {
        private final String name;
        private final List<TagItem> tags = new ArrayList<TagItem>();

        CompositeInfoItem(@NotNull TagItem item) {
            this.name = item.getName();
            this.tags.add(item);
        }

        public String getName() {
            return this.name;
        }

        public List<TagItem> getTags() {
            return this.tags;
        }

        public void addItem(@NotNull TagItem item) {
            this.tags.add(item);
        }

        @Override
        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }
    }
}

