/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPassListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDocumentListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlLoader;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OverlayMapping;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFragmentVirtualFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class ClangTidyAnnotator
extends ExternalAnnotator<ClangTidyAnnotatorInfo, ClangTidyAnnotationHolder> {
    public static final Key<Boolean> RUN_IN_UNIT_TEST_MODE = Key.create((String)"CLANG_TIDY_ANNOTATOR_RUN_IN_UNIT_TEST_MODE");
    public static final Key<Boolean> TAKE_CLION_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_CLION_CONFIG");
    public static final Key<Boolean> TAKE_TIDY_CONFIG = Key.create((String)"CLANG_TIDY_ANNOTATOR_TAKE_TIDY_CONFIG");
    public static final Key<Boolean> COLLECT_DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_COLLECT_DEBUG_INFORMATION");
    public static final Key<String> DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_DEBUG_INFORMATION");
    public static final Key<AtomicBoolean> HAS_DOCUMENT_LISTENER = Key.create((String)"CLANG_TIDY_HAS_DOCUMENT_LISTENER");
    public static final Key<MyMasterReparsingPassListener> REPARSING_PASS_LISTENER = Key.create((String)"CLANG_TIDY_REPARSING_PASS_LISTENER");
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator");
    private static final ClangTidyDocumentListener DOCUMENT_LISTENER = new ClangTidyDocumentListener();
    private final ClangTidyInspection myPairedInspection;

    public ClangTidyAnnotator() {
        this.myPairedInspection = null;
    }

    public ClangTidyAnnotator(@NotNull ClangTidyInspection inspection) {
        this.myPairedInspection = inspection;
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file2, @NotNull Editor editor, boolean hasErrors) {
        return this.collectInformationImpl(file2, editor);
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file2) {
        return this.collectInformationImpl(file2, null);
    }

    @Nullable
    private ClangTidyAnnotatorInfo collectInformationImpl(@NotNull PsiFile file2, @Nullable Editor editor) {
        ClangTidyInspection inspection;
        Project project2 = file2.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() && project2.getUserData(RUN_IN_UNIT_TEST_MODE) != Boolean.TRUE) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null || virtualFile instanceof OCFragmentVirtualFile) {
            return null;
        }
        String inputFileName = PathUtil.getFileName((String)virtualFile.getPath());
        OCPsiFile ocFile = OCLanguageUtils.asOCPsiFile(file2);
        if (ocFile == null || !ocFile.isInProjectSources()) {
            return null;
        }
        OCResolveRootAndConfiguration resolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
        OCResolveConfiguration configuration = resolveRootAndConfiguration.getConfiguration();
        VirtualFile rootVirtualFile = resolveRootAndConfiguration.getRootFile();
        OCLanguageKind languageKind = resolveRootAndConfiguration.getKind();
        if (configuration == null || rootVirtualFile == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, virtualFile);
        OCCompilerKind compiler = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir();
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches();
        if (compiler == null || compilerExecutable == null || compilerWorkingDir == null || compilerSwitches == null) {
            return null;
        }
        List<HeadersSearchPath> headerPaths = configuration.getCompilerSettings(languageKind, rootVirtualFile).getHeadersSearchPaths();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document2 == null) {
            return null;
        }
        ClangTidyInspection clangTidyInspection = inspection = this.myPairedInspection != null ? this.myPairedInspection : ClangTidyUtil.getInspection(ocFile, project2);
        if (inspection == null) {
            return null;
        }
        return new ClangTidyAnnotatorInfo(inputFileName, project2, ocFile, configuration, compilerSettings, compiler, compilerExecutable, compilerWorkingDir, compilerSwitches, rootVirtualFile, headerPaths, document2, inspection, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        if (info == null) {
            return null;
        }
        ClangTidyAnnotator.tryRegisterDocumentListener(info);
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"clion-clang-tidy", null, (boolean)true);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotator.executeClangTidy(info, workingDirectory);
            return clangTidyAnnotationHolder;
        }
        catch (com.intellij.execution.ExecutionException | IOException | YAMLException exc) {
            LOG.warn(exc);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotationHolder.error(exc.getMessage());
            return clangTidyAnnotationHolder;
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    public static boolean isAvailable() {
        return ClangTidyAnnotator.isAvailable(ClangTidyAnnotator.getBuiltinClangTidyPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static ClangTidyAnnotationHolder executeClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, com.intellij.execution.ExecutionException {
        if (ClangTidyAnnotator.useLanguageService(info)) {
            ClangUtils.infoClangd(LOG, "Clangd is used for clang-tidy diagnostics");
            ProgressIndicator currentIndicator = ProgressManager.getInstance().getProgressIndicator();
            SensitiveProgressWrapper newIndicator = currentIndicator != null ? new SensitiveProgressWrapper(currentIndicator) : new ProgressIndicatorBase();
            Ref result2 = Ref.create();
            MyMasterReparsingPassListener masterListener = ClangTidyAnnotator.trySubscribeForClangReparsingPass(info.getProject());
            MySlaveReparsingPassListener slaveListener = new MySlaveReparsingPassListener((ProgressIndicator)newIndicator, info.getFile());
            try {
                masterListener.addListener(slaveListener);
                ProgressManager.getInstance().runProcess(() -> {
                    Boolean isFileValid = (Boolean)ReadAction.compute(() -> info.getFile().isValid());
                    if (!isFileValid.booleanValue()) {
                        return;
                    }
                    ClangLanguageService languageService = ClangLanguageServiceProvider.getIfStarted(info.getProject());
                    result2.set((Object)languageService.computeWithParsed(info.getFile().getVirtualFile(), response -> {
                        if (response == null) {
                            return null;
                        }
                        try {
                            ArrayList<ClangTidyDiagnostic> diagnostics2 = new ArrayList<ClangTidyDiagnostic>();
                            for (Future<Supplier<List<ClangTidyDiagnostic>>> future : ClangTidyAnnotator.getDiagnosticsFutures(response, info.getProject())) {
                                Supplier<List<ClangTidyDiagnostic>> supplier = ClangUtils.waitCancelAware(future, Long.MAX_VALUE, "Clang-tidy diagnostics");
                                if (supplier != null) {
                                    List<ClangTidyDiagnostic> diags = supplier.get();
                                    if (diags != null) {
                                        diagnostics2.addAll(diags);
                                        continue;
                                    }
                                    return null;
                                }
                                return null;
                            }
                            return ClangTidyAnnotationHolder.success(diagnostics2);
                        }
                        catch (ExecutionException | TimeoutException exception) {
                            return null;
                        }
                    }));
                }, (ProgressIndicator)newIndicator);
            }
            finally {
                masterListener.removeListener(slaveListener);
            }
            return (ClangTidyAnnotationHolder)result2.get();
        }
        ClangUtils.infoClangd(LOG, "Clang-tidy is used for clang-tidy diagnostics");
        boolean collectDebugInformation = info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
        StringBuilder debugInformation = new StringBuilder();
        File clangTidyPath = ClangTidyAnnotator.getClangTidyPath();
        if (!ClangTidyAnnotator.isAvailable(clangTidyPath)) {
            return ClangTidyAnnotationHolder.error(OCInspectionsBundle.message("inspection.clangTidy.not.found", new Object[0]));
        }
        Document document2 = info.getDocument();
        long modificationStampOnStart = document2.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        OverlayMapping overlayMapping = ClangTidyAnnotator.generateVfsOverlays(workingDirectory);
        File vfsOverlay = ClangTidyAnnotator.generateVfsOverlay(overlayMapping, workingDirectory);
        File outputFile = new File(workingDirectory, "output.yaml");
        File compilationDatabase = ClangTidyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile);
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Compilation Database", FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(clangTidyPath.getAbsolutePath());
        ClangTidyInspection inspection = info.getInspection();
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)info.getProject().getService(ClangTidyFilesState.class);
        if (!inspection.isPreferClangTidyFilesOverIDESettings() || !clangTidyFilesState.hasClangTidyFilesInPath(inputFile)) {
            commandLine.addParameter("-config=" + ClangTidyUtil.getClangTidyConfig(ClangTidyUtil.concatClangTidyChecks(inspection.getClangTidyChecks(), "-clion-*"), inspection.getClangTidyCheckOptions()));
        } else {
            commandLine.addParameter("-checks=-clion-*");
        }
        commandLine.addParameter("-p=" + workingDirectory);
        commandLine.addParameter("-vfsoverlay=" + vfsOverlay);
        commandLine.addParameter("-export-fixes=" + outputFile);
        commandLine.addParameter(inputFile.getAbsolutePath());
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Command-Line", commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClangTidyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document2.getModificationStamp()) {
            return null;
        }
        if (progressIndicator != null) {
            processHandler.runProcessWithProgressIndicator(progressIndicator);
        } else {
            processHandler.runProcess();
        }
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Output", outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, debugInformation.toString());
        }
        List<ClangTidyDiagnostic> diagnostics2 = outputFile.exists() ? ClangTidyAnnotator.loadDiagnosticsFromYaml(outputFile, inputFile, overlayMapping) : Collections.emptyList();
        return ClangTidyAnnotationHolder.success(diagnostics2);
    }

    @NotNull
    private static List<Future<Supplier<List<ClangTidyDiagnostic>>>> getDiagnosticsFutures(@NotNull ClangParseResponse response, @NotNull Project project2) {
        ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>> futures2 = new ArrayList<Future<Supplier<List<ClangTidyDiagnostic>>>>();
        if (project2.getUserData(TAKE_CLION_CONFIG) == Boolean.TRUE) {
            futures2.add(response.getOurTidyDiagnostics());
        }
        if (project2.getUserData(TAKE_TIDY_CONFIG) != Boolean.FALSE) {
            futures2.add(response.getTidyDiagnostics());
        }
        return futures2;
    }

    private static OverlayMapping generateVfsOverlays(@NotNull File workingDirectory) throws IOException {
        OverlayMapping overlayMapping = new OverlayMapping();
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        for (Document unsavedDocument : documentManager.getUnsavedDocuments()) {
            VirtualFile virtualFile = documentManager.getFile(unsavedDocument);
            if (virtualFile == null) continue;
            File sourceFile = new File(virtualFile.getPath());
            File overlayFile = ClangTidyAnnotator.generateMappingFile(sourceFile.getName(), unsavedDocument, workingDirectory);
            overlayMapping.addOverlay(sourceFile, overlayFile);
        }
        return overlayMapping;
    }

    private static File generateMappingFile(@NotNull String fileName, @NotNull Document document2, @NotNull File workingDirectory) throws IOException {
        File mappingFile = new File(workingDirectory, fileName);
        FileUtil.writeToFile((File)mappingFile, (String)document2.getText());
        return mappingFile;
    }

    private static File generateVfsOverlay(@NotNull OverlayMapping overlayMapping, @NotNull File workingDirectory) throws IOException {
        File vfsOverlay = new File(workingDirectory, "overlay.yaml");
        FileUtil.writeToFile((File)vfsOverlay, (String)ClangTidyUtil.generateVfsOverlay(overlayMapping));
        return vfsOverlay;
    }

    public void apply(@NotNull PsiFile file2, @Nullable ClangTidyAnnotationHolder annotationHolder, @NotNull AnnotationHolder holder) {
        Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (annotationHolder == null || document2 == null) {
            return;
        }
        ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
        if (annotationHolder.isSuccess()) {
            applier.applySuccess(file2, document2, annotationHolder.getDiagnostics(), holder);
        } else {
            HighlightSeverity severity = annotationHolder.isError() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            applier.applyFail(file2, annotationHolder.getFailReason(), severity, holder);
        }
    }

    @NotNull
    public static File getBuiltinClangTidyPath() {
        return ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clang-tidy.exe" : "clang-tidy");
    }

    @NotNull
    private static File createCompilationDatabase(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory, @NotNull File inputFile) throws IOException {
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        Application application = ApplicationManager.getApplication();
        Ref compilerExecutableRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        application.runReadAction(() -> {
            if (info.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            OCResolveConfiguration configuration = info.getConfiguration();
            OCLanguageKind languageKind = info.getLanguageKind();
            VirtualFile rootVirtualFile = info.getRootVirtualFile();
            File compilerExecutable = info.getCompilerExecutable();
            compilerExecutableRef.set((Object)compilerExecutable.getAbsolutePath());
            ClangTidyAnnotator.addCompilerSwitches(info, compilerOptions);
            ClangTidyAnnotator.addIncludeDirectories(info, compilerOptions);
            preprocessorDefinesRef.set((Object)configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines());
            return null;
        });
        compilerOptions.addSingleRaw("-ferror-limit=0");
        if (!preprocessorDefinesRef.isNull()) {
            File macrosFile = new File(workingDirectory, "macros");
            FileUtil.writeToFile((File)macrosFile, (String)((String)preprocessorDefinesRef.get()));
            compilerOptions.addSingleRaw("-Xclang");
            compilerOptions.addSingleRaw("-imacros" + macrosFile.getAbsolutePath());
        }
        File compilationDatabase = new File(workingDirectory, "compile_commands.json");
        FileWriter writer = new FileWriter(compilationDatabase);
        ClangTidyUtil.writeCompilationDatabase(writer, (String)compilerExecutableRef.get(), workingDirectory.getAbsolutePath(), compilerOptions.getArgs(), inputFile.getAbsolutePath());
        return compilationDatabase;
    }

    private static void addCompilerSwitches(@NotNull ClangTidyAnnotatorInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        switchBuilder.addAll(ClangTidyAnnotator.filterCompilerSwitches(info.getCompilerSwitches()));
    }

    private static CidrCompilerSwitches filterCompilerSwitches(@NotNull CidrCompilerSwitches compilerSwitches) {
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                if (parameter.equals("-F") || parameter.equals("-I") || parameter.equals("-iquote")) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (parameter.startsWith("-F") || parameter.startsWith("-I") || parameter.startsWith("-iquote")) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    private static void addIncludeDirectories(@NotNull ClangTidyAnnotatorInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        ClangUtils.addIncludeDirectories(info, switchBuilder, null, true);
    }

    @NotNull
    private static File getClangTidyPath() {
        File clangTidyPath = ClangTidyUtil.getCustomClangTidyPath();
        if (clangTidyPath == null) {
            clangTidyPath = ClangTidyAnnotator.getBuiltinClangTidyPath();
        }
        return clangTidyPath;
    }

    private static boolean isAvailable(@Nullable File clangTidyPath) {
        try {
            return clangTidyPath != null && clangTidyPath.exists() && clangTidyPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static void putDebugInformation(@NotNull StringBuilder builder2, @NotNull String informationHeader, @NotNull String content) {
        builder2.append("=== ").append(informationHeader).append(" ===").append("\n");
        builder2.append(content).append("\n\n");
    }

    @NotNull
    private static List<ClangTidyDiagnostic> loadDiagnosticsFromYaml(@NotNull File outputFile, @NotNull File sourceFile, @NotNull OverlayMapping overlayMapping) throws IOException {
        String yamlContent = FileUtil.loadFile((File)outputFile);
        ClangTidyYamlLoader yamlLoader = new ClangTidyYamlLoader();
        return yamlLoader.load(yamlContent, sourceFile.getPath(), overlayMapping);
    }

    private static void tryRegisterDocumentListener(@NotNull ClangTidyAnnotatorInfo info) {
        Document document2 = info.getDocument();
        if (!(document2 instanceof UserDataHolderEx)) {
            return;
        }
        UserDataHolderEx dataHolder = (UserDataHolderEx)document2;
        AtomicBoolean hasDocumentListener = (AtomicBoolean)dataHolder.getUserData(HAS_DOCUMENT_LISTENER);
        if (hasDocumentListener == null && dataHolder.putUserDataIfAbsent(HAS_DOCUMENT_LISTENER, (Object)(hasDocumentListener = new AtomicBoolean(false))) != hasDocumentListener) {
            return;
        }
        if (hasDocumentListener.compareAndSet(false, true)) {
            document2.addDocumentListener((DocumentListener)DOCUMENT_LISTENER);
        }
    }

    @NotNull
    private static MyMasterReparsingPassListener trySubscribeForClangReparsingPass(@NotNull Project project2) {
        if (!(project2 instanceof UserDataHolderEx)) {
            LOG.warn("Unexpected project type: " + project2.getClass().getSimpleName());
            return new MyMasterReparsingPassListener();
        }
        MyMasterReparsingPassListener existing = (MyMasterReparsingPassListener)project2.getUserData(REPARSING_PASS_LISTENER);
        if (existing != null) {
            return existing;
        }
        UserDataHolderEx dataHolderEx = (UserDataHolderEx)project2;
        MyMasterReparsingPassListener newMasterListener = new MyMasterReparsingPassListener();
        MyMasterReparsingPassListener existing2 = (MyMasterReparsingPassListener)dataHolderEx.putUserDataIfAbsent(REPARSING_PASS_LISTENER, (Object)newMasterListener);
        if (existing2 == newMasterListener) {
            project2.getMessageBus().connect().subscribe(OCLanguageServiceReparsingPassListener.TOPIC, (Object)newMasterListener);
        }
        return existing2;
    }

    public String getPairedBatchInspectionShortName() {
        return ClangTidyInspection.getInspectionShortName();
    }

    @NotNull
    private static CapturingProcessHandler createCapturedProcessHandler(@NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        return new CapturingProcessHandler(commandLine){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingProcessAdapter(processOutput){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    }
                };
            }
        };
    }

    private static boolean useLanguageService(@NotNull ClangTidyAnnotatorInfo info) {
        Project project2 = info.getProject();
        if (ClangUtils.isClangdOn(project2) && ClangUtils.isClangTidyViaClangdOn(project2)) {
            if (info.getFile().getVirtualFile() == null) {
                return false;
            }
            if (ClangUtils.isClangTidyViaClangdForced(project2)) {
                return true;
            }
            return ClangTidyUtil.getCustomClangTidyPath() == null && info.getEditor() != null;
        }
        return false;
    }

    private static class MySlaveReparsingPassListener {
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private final PsiFile myFile;

        private MySlaveReparsingPassListener(@NotNull ProgressIndicator indicator, @NotNull PsiFile file2) {
            this.myIndicator = indicator;
            this.myFile = file2;
        }

        public void onReparsing(@NotNull PsiFile file2) {
            if (file2 == this.myFile) {
                this.myIndicator.cancel();
            }
        }
    }

    private static class MyMasterReparsingPassListener
    implements OCLanguageServiceReparsingPassListener {
        @NotNull
        private final Set<MySlaveReparsingPassListener> mySlaveListeners = Collections.newSetFromMap(new IdentityHashMap());

        private MyMasterReparsingPassListener() {
        }

        @Override
        public synchronized void onReparsing(@NotNull PsiFile file2) {
            for (MySlaveReparsingPassListener slave : this.mySlaveListeners) {
                slave.onReparsing(file2);
            }
        }

        synchronized void addListener(@NotNull MySlaveReparsingPassListener slave) {
            this.mySlaveListeners.add(slave);
        }

        synchronized void removeListener(@NotNull MySlaveReparsingPassListener slave) {
            this.mySlaveListeners.remove(slave);
        }
    }
}

