/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatLog;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangFormatFileUtils {
    public static final Key<Boolean> NEW_PROJECT_GENERATION_IN_PROGRESS = Key.create((String)"NEW_PROJECT_GENERATION_IN_PROGRESS");
    @NonNls
    public static final String CLANG_FORMAT_ID = "ClangFormat";
    @NonNls
    public static final String CLANG_FORMAT_FILE_PREFIX = "clang-format-file://";
    @NonNls
    public static final String CLANG_FORMAT_SETTINGS_ID = "clangFormatSettings";
    @NonNls
    public static final String CLANG_FORMAT1 = ".clang-format";
    @NonNls
    public static final String CLANG_FORMAT2 = "_clang-format";
    @NonNls
    public static final String CLANG_FORMAT_DEFAULT = "# The default implementation for the project without .clang-format\nBasedOnStyle: LLVM\n";
    @NonNls
    private static final String ourErrorPrefix = "# Error: ";
    @NonNls
    private static final String ourErrorSuffix = "";

    @Contract(pure=true)
    public static boolean isFileBasedClangFormatURL(@NotNull String url) {
        return url.startsWith(CLANG_FORMAT_FILE_PREFIX);
    }

    @Nullable
    public static VirtualFile getClangFormatFile(@NotNull String clangFormatURL, boolean refreshVFSIfNeeded) {
        String path = ClangFormatFileUtils.getClangFormatPathFromURL(clangFormatURL);
        try {
            return path == null ? null : VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)refreshVFSIfNeeded);
        }
        catch (Throwable e) {
            ClangFormatLog.LOG.warn(e);
            return null;
        }
    }

    public static CommonCodeStyleSettings.IndentOptions getOverriddenIndentOptions(@NotNull TransientCodeStyleSettings transientSettings) {
        PsiFile codeFile = transientSettings.getPsiFile();
        if (codeFile == null) {
            return CommonCodeStyleSettings.IndentOptions.DEFAULT_INDENT_OPTIONS;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (application.isWriteAccessAllowed()) {
                ClangFormatFileUtils.saveAllClangFormatDocuments();
            } else {
                ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith((Disposable)codeFile.getProject())).submit(() -> ClangFormatFileUtils.saveAllClangFormatDocuments());
            }
        }
        return transientSettings.getLanguageIndentOptions(codeFile.getLanguage());
    }

    public static void saveAllClangFormatDocuments() {
        Document[] unsavedDocuments;
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document2 : unsavedDocuments = fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file2 = fileDocumentManager.getFile(document2);
            if (file2 == null || !ClangFormatFileUtils.isClangFormatConfig(file2)) continue;
            fileDocumentManager.saveDocument(document2);
        }
    }

    public static boolean isClangFormatConfig(@NotNull VirtualFile file2) {
        return ClangFormatFileUtils.isClangFormatName(file2.getName());
    }

    public static boolean isClangFormatName(String name) {
        return CLANG_FORMAT1.equals(name) || CLANG_FORMAT2.equals(name);
    }

    @Nullable
    public static String getClangFormatPathFromURL(@NotNull String clangFormatURL) {
        if (!ClangFormatFileUtils.isFileBasedClangFormatURL(clangFormatURL)) {
            return null;
        }
        return clangFormatURL.substring(CLANG_FORMAT_FILE_PREFIX.length());
    }

    @NotNull
    public static String getClangFormatFileURL(@NotNull VirtualFile clangFormat) {
        return CLANG_FORMAT_FILE_PREFIX + clangFormat.getCanonicalPath();
    }

    @NotNull
    public static String convertCurrentCodeStyleToClangFormat(@NotNull CodeStyleSettings style) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("# Generated from CLion C/C++ Code Style settings\n");
        stringBuilder.append("BasedOnStyle: LLVM\n");
        CommonCodeStyleSettings commonSettings = style.getCommonSettings((Language)OCLanguage.getInstance());
        CommonCodeStyleSettings.IndentOptions indentSettings = commonSettings.getIndentOptions();
        if (indentSettings == null) {
            indentSettings = style.getIndentOptions();
        }
        OCCodeStyleSettings cppCodeStyleSettings = (OCCodeStyleSettings)style.getCustomSettings(OCCodeStyleSettings.class);
        stringBuilder.append("AccessModifierOffset: ").append(cppCodeStyleSettings.INDENT_VISIBILITY_KEYWORDS - indentSettings.INDENT_SIZE).append('\n');
        stringBuilder.append("AlignAfterOpenBracket: ").append(commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE ? "AlwaysBreak" : (commonSettings.ALIGN_MULTILINE_PARAMETERS ? "Align" : "DontAlign")).append('\n');
        stringBuilder.append("AlignConsecutiveAssignments: ").append(commonSettings.ALIGN_GROUP_FIELD_DECLARATIONS).append('\n');
        stringBuilder.append("AlignOperands: ").append(commonSettings.ALIGN_MULTILINE_BINARY_OPERATION).append('\n');
        stringBuilder.append("AllowAllArgumentsOnNextLine: ").append(commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE).append('\n');
        stringBuilder.append("AllowAllConstructorInitializersOnNextLine: ").append(cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON == 1).append('\n');
        stringBuilder.append("AllowAllParametersOfDeclarationOnNextLine: ").append(commonSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).append('\n');
        stringBuilder.append("AllowShortBlocksOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? "Always" : (commonSettings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE ? "Empty" : "Never")).append('\n');
        stringBuilder.append("AllowShortCaseLabelsOnASingleLine: ").append(cppCodeStyleSettings.KEEP_CASE_EXPRESSIONS_IN_ONE_LINE).append('\n');
        stringBuilder.append("AllowShortFunctionsOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE ? "All" : "None").append('\n');
        stringBuilder.append("AllowShortIfStatementsOnASingleLine: ").append(commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE ? "Always" : "Never").append('\n');
        stringBuilder.append("AllowShortLambdasOnASingleLine: ").append(commonSettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE ? "All" : "None").append('\n');
        stringBuilder.append("AllowShortLoopsOnASingleLine: ").append(commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE).append('\n');
        stringBuilder.append("AlwaysBreakAfterReturnType: ").append(cppCodeStyleSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP == 2 ? (cppCodeStyleSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP == 2 ? "All" : "TopLevel") : "None").append('\n');
        stringBuilder.append("AlwaysBreakTemplateDeclarations: ").append(cppCodeStyleSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP == 2 ? "Yes" : (cppCodeStyleSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP == 1 ? "MultiLine" : "No")).append('\n');
        stringBuilder.append("BreakBeforeBraces: Custom\n");
        stringBuilder.append("BraceWrapping:\n");
        stringBuilder.append("  AfterCaseLabel: false\n");
        stringBuilder.append("  AfterClass: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  AfterControlStatement: ").append(commonSettings.BRACE_STYLE == 5 ? "MultiLine" : (commonSettings.BRACE_STYLE != 1 ? "Always" : "Never")).append('\n');
        stringBuilder.append("  AfterEnum: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  AfterFunction: ").append(cppCodeStyleSettings.FUNCTION_BRACE_PLACEMENT != 1).append('\n');
        stringBuilder.append("  AfterNamespace: ").append(cppCodeStyleSettings.NAMESPACE_BRACE_PLACEMENT != 1).append('\n');
        stringBuilder.append("  AfterUnion: ").append(commonSettings.CLASS_BRACE_STYLE != 1).append('\n');
        stringBuilder.append("  BeforeCatch: ").append(commonSettings.CATCH_ON_NEW_LINE).append('\n');
        stringBuilder.append("  BeforeElse: ").append(commonSettings.ELSE_ON_NEW_LINE).append('\n');
        stringBuilder.append("  IndentBraces: ").append(commonSettings.BRACE_STYLE == 3).append('\n');
        stringBuilder.append("  SplitEmptyFunction: ").append(!commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE).append('\n');
        stringBuilder.append("  SplitEmptyRecord: ").append(!commonSettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE).append('\n');
        stringBuilder.append("BreakBeforeBinaryOperators: ").append(commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? (commonSettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE ? "All" : "NonAssignment") : "None").append('\n');
        stringBuilder.append("BreakBeforeTernaryOperators: ").append(commonSettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE).append('\n');
        stringBuilder.append("BreakConstructorInitializers: ").append(cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON == 1 ? "AfterColon" : (cppCodeStyleSettings.CLASS_CONSTRUCTOR_INIT_LIST_COMMA_ON_NEXT_LINE ? "BeforeComma" : "BeforeColon")).append('\n');
        stringBuilder.append("BreakInheritanceList: ").append(cppCodeStyleSettings.SUPERCLASS_LIST_AFTER_COLON == 1 ? "AfterColon" : (cppCodeStyleSettings.SUPERCLASS_LIST_COMMA_ON_NEXT_LINE ? "BeforeComma" : "BeforeColon")).append('\n');
        stringBuilder.append("ColumnLimit: ").append(commonSettings.KEEP_LINE_BREAKS ? 0 : (commonSettings.RIGHT_MARGIN > 0 ? commonSettings.RIGHT_MARGIN : 120)).append('\n');
        stringBuilder.append("CompactNamespaces: ").append(cppCodeStyleSettings.KEEP_NESTED_NAMESPACES_IN_ONE_LINE).append('\n');
        stringBuilder.append("ContinuationIndentWidth: ").append(indentSettings.CONTINUATION_INDENT_SIZE).append('\n');
        stringBuilder.append("IndentCaseLabels: ").append(commonSettings.INDENT_CASE_FROM_SWITCH).append('\n');
        stringBuilder.append("IndentPPDirectives: ").append(cppCodeStyleSettings.INDENT_PREPROCESSOR_DIRECTIVE > 0 ? "BeforeHash" : "None").append('\n');
        stringBuilder.append("IndentWidth: ").append(indentSettings.INDENT_SIZE).append('\n');
        stringBuilder.append("KeepEmptyLinesAtTheStartOfBlocks: ").append(commonSettings.KEEP_BLANK_LINES_IN_CODE > 0).append('\n');
        stringBuilder.append("MaxEmptyLinesToKeep: ").append(commonSettings.KEEP_BLANK_LINES_IN_CODE).append('\n');
        stringBuilder.append("NamespaceIndentation: ").append(cppCodeStyleSettings.INDENT_NAMESPACE_MEMBERS > 0 ? "All" : "None").append('\n');
        stringBuilder.append("ObjCSpaceAfterProperty: ").append(cppCodeStyleSettings.SPACE_BEFORE_PROPERTY_ATTRIBUTES_PARENTHESES).append('\n');
        stringBuilder.append("ObjCSpaceBeforeProtocolList: ").append(cppCodeStyleSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS).append('\n');
        stringBuilder.append("PointerAlignment: ").append(cppCodeStyleSettings.SPACE_BEFORE_POINTER_IN_DECLARATION ? (cppCodeStyleSettings.SPACE_AFTER_POINTER_IN_DECLARATION ? "Middle" : "Right") : "Left").append('\n');
        stringBuilder.append("ReflowComments: ").append(commonSettings.WRAP_COMMENTS).append('\n');
        stringBuilder.append("SpaceAfterCStyleCast: ").append(commonSettings.SPACE_AFTER_TYPE_CAST).append('\n');
        stringBuilder.append("SpaceAfterLogicalNot: ").append(commonSettings.SPACE_AROUND_UNARY_OPERATOR).append('\n');
        stringBuilder.append("SpaceAfterTemplateKeyword: ").append(cppCodeStyleSettings.SPACE_BEFORE_TEMPLATE_DECLARATION_LT).append('\n');
        stringBuilder.append("SpaceBeforeAssignmentOperators: ").append(commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS).append('\n');
        stringBuilder.append("SpaceBeforeCpp11BracedList: ").append(cppCodeStyleSettings.SPACE_BEFORE_INIT_LIST).append('\n');
        stringBuilder.append("SpaceBeforeCtorInitializerColon: ").append(cppCodeStyleSettings.SPACE_BEFORE_INIT_LIST_COLON).append('\n');
        stringBuilder.append("SpaceBeforeInheritanceColon: ").append(cppCodeStyleSettings.SPACE_BEFORE_SUPERCLASS_COLON).append('\n');
        boolean spaceBeforeControlStatementParen = commonSettings.SPACE_BEFORE_IF_PARENTHESES || commonSettings.SPACE_BEFORE_FOR_PARENTHESES || commonSettings.SPACE_BEFORE_WHILE_PARENTHESES || commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES || commonSettings.SPACE_BEFORE_CATCH_PARENTHESES;
        stringBuilder.append("SpaceBeforeParens: ").append(spaceBeforeControlStatementParen ? (commonSettings.SPACE_BEFORE_METHOD_PARENTHESES ? "Always" : "ControlStatements") : "Never").append('\n');
        stringBuilder.append("SpaceBeforeRangeBasedForLoopColon: ").append(commonSettings.SPACE_BEFORE_COLON).append('\n');
        stringBuilder.append("SpaceInEmptyParentheses: ").append(commonSettings.SPACE_WITHIN_EMPTY_METHOD_CALL_PARENTHESES).append('\n');
        stringBuilder.append("SpacesBeforeTrailingComments: ").append(commonSettings.LINE_COMMENT_ADD_SPACE ? 1 : 0).append('\n');
        stringBuilder.append("SpacesInAngles: ").append(cppCodeStyleSettings.SPACE_WITHIN_TEMPLATE_DECLARATION_LTGT).append('\n');
        stringBuilder.append("SpacesInCStyleCastParentheses: ").append(commonSettings.SPACE_WITHIN_CAST_PARENTHESES).append('\n');
        stringBuilder.append("SpacesInContainerLiterals: ").append(cppCodeStyleSettings.SPACE_BEFORE_DICTIONARY_LITERAL_COLON).append('\n');
        stringBuilder.append("SpacesInParentheses: ").append(commonSettings.SPACE_WITHIN_PARENTHESES).append('\n');
        stringBuilder.append("SpacesInSquareBrackets: ").append(commonSettings.SPACE_WITHIN_BRACKETS).append('\n');
        stringBuilder.append("TabWidth: ").append(indentSettings.TAB_SIZE).append('\n');
        stringBuilder.append("UseTab: ").append(indentSettings.USE_TAB_CHARACTER ? (indentSettings.SMART_TABS ? "ForIndentation" : "ForContinuationAndIndentation") : "Never").append('\n');
        return stringBuilder.toString();
    }

    public static boolean exportSettingsToClangFormatFileInDirectory(@NotNull Project project2, @NotNull VirtualFile directory) {
        assert (directory.isDirectory());
        try {
            WriteCommandAction.writeCommandAction((Project)project2).withName(ClangdBundle.message("cf.create.cf.file.action.name", new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
                if (ClangFormatFileUtils.hasClangFormatFileInDirectory(directory, CLANG_FORMAT1)) {
                    throw new FileAlreadyExistsException(CLANG_FORMAT1);
                }
                VirtualFile vfClangFormat = directory.createChildData((Object)project2, CLANG_FORMAT1);
                vfClangFormat.setCharset(StandardCharsets.UTF_8);
                VfsUtil.saveText((VirtualFile)vfClangFormat, (String)ClangFormatFileUtils.convertCurrentCodeStyleToClangFormat(CodeStyle.getSettings((Project)project2)));
                if (!ApplicationManager.getApplication().isUnitTestMode() && NEW_PROJECT_GENERATION_IN_PROGRESS.get((UserDataHolder)project2) == null) {
                    FileEditorManager.getInstance((Project)project2).openFile(vfClangFormat, true);
                }
            });
        }
        catch (Throwable e) {
            if (e.getCause() instanceof FileAlreadyExistsException) {
                return false;
            }
            ExceptionUtil.rethrow((Throwable)e);
        }
        return true;
    }

    public static boolean hasClangFormatFileInDirectory(@NotNull VirtualFile directory, @NonNls @NotNull String cfName) {
        VirtualFile vfClangFormat = directory.findChild(cfName);
        if (vfClangFormat instanceof VirtualFileImpl && ((VirtualFileImpl)vfClangFormat).isDirty()) {
            vfClangFormat.refresh(false, false);
            vfClangFormat = directory.findChild(cfName);
        }
        return vfClangFormat != null;
    }

    @NotNull
    public static String getErrorStyleFor(@NotNull String message) {
        return ourErrorPrefix + message + ourErrorSuffix + "\n";
    }

    @Nullable
    public static String getErrorMessageFromYAMLine(@NotNull String lineWithError) {
        if (lineWithError.length() >= ourErrorPrefix.length() + ourErrorSuffix.length() && lineWithError.startsWith(ourErrorPrefix) && lineWithError.endsWith(ourErrorSuffix)) {
            return lineWithError.substring(ourErrorPrefix.length(), lineWithError.length() - ourErrorSuffix.length());
        }
        return null;
    }
}

